/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.service.impl;

import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.service.BatchCollectService;
import com.efuture.msboot.service.support.ActionResult;
import com.efuture.msboot.service.support.CollectAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class BatchCollectServiceImpl
implements BatchCollectService {
    private static final Logger log = LoggerFactory.getLogger(BatchCollectServiceImpl.class);
    @Value(value="${msboot.service.batchcollect.theads:10}")
    private Integer theadsCount;
    private ExecutorService threadPool;

    @PostConstruct
    public void init() {
        this.threadPool = Executors.newFixedThreadPool(this.theadsCount);
    }

    @Override
    public Map<String, Object> exec(List<CollectAction> taskList) {
        return this.exec(taskList, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Map<String, Object> exec(List<CollectAction> taskList, long timeout, TimeUnit unit) {
        final SessionContext sessionContext = SessionContextHolder.get();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>();
        for (final CollectAction collectAction : taskList) {
            Future<Object> future = this.threadPool.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        SessionContextHolder.put((SessionContext)sessionContext);
                        Object v = collectAction.doAction();
                        return v;
                    }
                    catch (Exception e) {
                        ActionResult actionResult = ActionResult.buildFail(e.getMessage());
                        return actionResult;
                    }
                    finally {
                        SessionContextHolder.remove();
                    }
                }
            });
            futureList.add(future);
        }
        for (Future future : futureList) {
            try {
                ActionResult actionResult;
                ActionResult actionResult2 = actionResult = timeout != 0L ? (ActionResult)future.get(timeout, unit) : (ActionResult)future.get();
                if (!actionResult.isSuccess()) {
                    ExceptionUtils.raise((String)("\u6267\u884c\u6279\u4efb\u52a1\u9519\u8bef:" + actionResult.getMessage()));
                }
                resultMap.put(actionResult.getKey(), actionResult.getValue());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultMap;
    }
}

