package com.efuture.msboot.exposer;

import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.service.BaseListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class BaseListExposer<S extends BaseListService<T>, T> {
    @Autowired
    protected S service;

    public DataPage<T> search(SearchInfo searchInfo){
        return service.search(searchInfo);
    }

    public T get(@RequestParam("id") Serializable id){
        return service.get(id);
    }

    public T getByMap(Map<String,Object> map){
        return service.getByMap(map);
    }

    public Map<String,T> dist(@RequestParam(name="paramsList") List<Map<String,Object>> paramsList){
        return service.dict(paramsList);
    }

    public T add(@Validated T entity){
        return service.add(entity);
    }

    public T update(@Validated T entity){
        return service.update(entity);
    }

    public List<Serializable> batchAdd(@RequestParam("entityList") List<T> entityList){
        return service.batchAdd(entityList);
    }

    public int delete(@RequestParam("id") Serializable id){
        return service.delete(id);
    }

    public int batchDelete(@RequestParam("ids") List<Serializable> ids){
        return service.batchDelete(ids);
    }
}
