package com.efuture.msboot.exposer;

import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.service.BaseSheetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.Serializable;

/**
 * Created by wzm on 2020/3/17.
 */
public class BaseSheetExposer<S extends BaseSheetService<T>, T> {
    @Autowired
    protected S service;

    public DataPage<T> search(SearchInfo searchInfo){
        return service.search(searchInfo);
    }

    public T get(@RequestParam("id") Serializable id){
        return service.get(id);
    }

    public T getBySheetId(@RequestParam("sheetId") String sheetId){
        return service.getBySheetId(sheetId);
    }

    public T save(T entity){
        return service.save(entity);
    }

    public void delete(@RequestParam("id") Serializable id){
        service.delete(id);
    }

    public void commit(@RequestParam("id") Serializable id){
        service.commit(id);
    }
}
