package com.efuture.msboot.service;


import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.query.bean.SearchInfo;

import java.io.Serializable;
import java.util.List;

/**
 * Created by wzm on 2018/9/8.
 */
public interface BaseSheetService<T> {
    /**
     * 获取单据，包含子表
     * @param id
     * @return
     */
    T get(Serializable id);

    /**
     * 获取单据
     * @param id
     * @param returnSheetDetails 是否返回子表
     * @return
     */
    T get(Serializable id, boolean returnSheetDetails);

    /**
     * 获取单据，包含子表
     * @param sheetId
     * @return
     */
    T getBySheetId(String sheetId);

    /**
     * 根据单据号获取单据头
     * @param sheetId
     * @return
     */
    T getBySheetId(String sheetId, boolean returnSheetDetails);

    /**
     * 获取单据状态
     * @param id
     * @return
     */
    Object getFlag(Serializable id);

    /**
     * 获取单据状态
     * @param sheetId
     * @return
     */
    Object getFlag(String sheetId);

    /**
     * 是否存在
     * @param id
     * @return
     */
    boolean exist(Serializable id);

    /**
     * 是否存在
     * @param sheetId
     * @return
     */
    boolean exist(String sheetId);

    /**
     * 新增
     * @param entity
     * @return
     */
    T add(T entity);

    /**
     * 修改
     * @param entity
     * @return
     */
    T update(T entity);

    /**
     * 删除
     * @param id
     */
    void delete(Serializable id);

    /**
     * 保存
     * @param entity
     * @return
     */
    T save(T entity);

    /**
     * 批量删除
     * @param ids
     */
    void batchDelete(List<Serializable> ids);

    /**
     * 搜索
     * @param searchInfo
     * @return
     */
    DataPage<T> search(SearchInfo searchInfo);

    /**
     * 提交
     * @param id
     */
    void commit(Serializable id);

    /**
     * 执行单据
     * @param id
     */
    void execture(Serializable id);

    /**
     * 获取新的单据号
     * @return
     */
    String getNewSheetId();

    /**
     * 获取新的单据号
     * @return
     */
    String getNewSheetId(String shopid);

    /**
     * 设置一个新的单据号
     * @param entity
     */
    void setNewSheetId(T entity);

    /**
     * 单据类型
     * @return
     */
    int getSheetType();
}
