package com.efuture.msboot.service.entity;

import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.service.ShopSplitConfigService;
import com.efuture.msboot.service.bean.ShopSplitConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;
import java.util.HashSet;
import java.util.Set;

@Slf4j
public class ShopSplitEntityInitializer extends DefaultEntityInitializer {

    @Autowired
    ShopSplitConfigService shopSplitConfigService;

    @Value("${msboot.service.splitconfig.shopidFields:shopid,shopcode,orgcode,org_code}")
    private String shopidFields;

    @Value("${msboot.service.splitconfig.splitcodeFields:splitcode}")
    private String splitcodeFields;

    private Set<String> shopidFieldSet;
    private Set<String> splitcodeSet;

    @PostConstruct
    public void init(){
        this.shopidFieldSet = new HashSet<>();
        this.splitcodeSet = new HashSet<>();

        String[] records = shopidFields.split(",");
        for(String r:records){
            this.shopidFieldSet.add(r.trim());
        }

        records = splitcodeFields.split(",");
        for(String r:records){
            this.splitcodeSet.add(r.trim());
        }
    }

    @Override
    public void initInsert(Object entity) {
        super.initInsert(entity);

        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        String splitCodeField = "";
        String shopIdField = "";

        for(String str:beanWrapper.getPropertiesSet()){
            if(StringUtils.hasText(splitCodeField) && StringUtils.hasText(shopIdField)){
                break;
            }

            if(this.splitcodeSet.contains(str.toLowerCase())){
                splitCodeField = str;
            }

            if(this.shopidFieldSet.contains(str.toLowerCase())){
                shopIdField = str;
            }
        }

        if(!StringUtils.hasText(splitCodeField)){
            return;
        }

        Object value = beanWrapper.getPropertyValue(splitCodeField);
        //已存在，则不处理
        if(value != null && StringUtils.hasText(String.valueOf(value))){
            return;
        }

        if(!StringUtils.hasText(shopIdField)){
            log.debug(">> 缺少 shopcode 字段，无法计算 splitcode");
            return;
        }

        value = beanWrapper.getPropertyValue(shopIdField);
        if(value == null || !StringUtils.hasText(String.valueOf(value))){
            ExceptionUtils.raise(shopIdField + " 字段为空，无法计算 splitcode");
        }

        String shopid = String.valueOf(value);
        ShopSplitConfig shopSplitConfig = shopSplitConfigService.getByShopId(shopid);

        if(shopSplitConfig == null || !StringUtils.hasText(shopSplitConfig.getSplitcode())){
            ExceptionUtils.raise(shopIdField+" "+shopid+" 没配置 splitcode 对应关系");
        }

        beanWrapper.setPropertyValue(splitCodeField, shopSplitConfig.getSplitcode());
    }


    @Override
    public void initUpdate(Object entity) {
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        String splitCodeField = "";

        for(String str:beanWrapper.getPropertiesSet()){
            if(this.splitcodeSet.contains(str.toLowerCase())){
                splitCodeField = str;
                break;
            }
        }

        if(StringUtils.hasText(splitCodeField)){
            beanWrapper.setPropertyValue(splitCodeField, null);
        }

        super.initUpdate(entity);
    }
}
