package com.efuture.msboot.service.impl;

import com.efuture.msboot.service.ServiceWrapper;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;

/**
 * Created by wzm on 2020/7/22.
 */
@Slf4j
public class ThreadServiceWrapperImpl implements ServiceWrapper {
    @Override
    public Object wrapper(Supplier action) {
        FutureTask<Object> future = new FutureTask<>(new Callable<Object>() {
            @Override
            public Object call() throws Exception {
                return action.get();
            }
        });

        Thread accessThread = new Thread(future);
        accessThread.start();

        Object result = null;
        try {
            result = future.get();
        }catch (Exception e){
            log.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        return result;
    }
}
