package com.efuture.msboot.service.support;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ActionResult {
    private boolean success = true;
    private String message;

    private String key;
    private Object value;

    public ActionResult(String key, Object value){
        this.key = key;
        this.value = value;
    }

    public static ActionResult buildSuccess(String key, Object value){
        return new ActionResult(key, value);
    }

    public static ActionResult buildFail(){
        return buildFail(null);
    }

    public static ActionResult buildFail(String message){
        ActionResult actionResult = new ActionResult();
        actionResult.setSuccess(false);
        actionResult.setMessage(message);

        return actionResult;
    }
}
