/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.service.entity;

import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.service.ShopSplitConfigService;
import com.efuture.msboot.service.bean.ShopSplitConfig;
import com.efuture.msboot.service.entity.DefaultEntityInitializer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class ShopSplitEntityInitializer
extends DefaultEntityInitializer {
    private static final Logger log = LoggerFactory.getLogger(ShopSplitEntityInitializer.class);
    @Autowired
    ShopSplitConfigService shopSplitConfigService;
    @Value(value="${msboot.service.splitconfig.shopidFields:shopid,shopcode,orgcode,org_code}")
    private String shopidFields;
    @Value(value="${msboot.service.splitconfig.splitcodeFields:splitcode}")
    private String splitcodeFields;
    private Set<String> shopidFieldSet;
    private Set<String> splitcodeSet;

    @PostConstruct
    public void init() {
        String[] records;
        this.shopidFieldSet = new HashSet<String>();
        this.splitcodeSet = new HashSet<String>();
        for (String r : records = this.shopidFields.split(",")) {
            this.shopidFieldSet.add(r.trim());
        }
        for (String r : records = this.splitcodeFields.split(",")) {
            this.splitcodeSet.add(r.trim());
        }
    }

    @Override
    public void initInsert(Object entity) {
        String shopid;
        ShopSplitConfig shopSplitConfig;
        super.initInsert(entity);
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        String splitCodeField = "";
        String shopIdField = "";
        for (String str : beanWrapper.getPropertiesSet()) {
            if (StringUtils.hasText((String)splitCodeField) && StringUtils.hasText((String)shopIdField)) break;
            if (this.splitcodeSet.contains(str.toLowerCase())) {
                splitCodeField = str;
            }
            if (!this.shopidFieldSet.contains(str.toLowerCase())) continue;
            shopIdField = str;
        }
        if (!StringUtils.hasText((String)splitCodeField)) {
            return;
        }
        Object value = beanWrapper.getPropertyValue(splitCodeField);
        if (value != null && StringUtils.hasText((String)String.valueOf(value))) {
            return;
        }
        if (!StringUtils.hasText((String)shopIdField)) {
            log.debug(">> \u7f3a\u5c11 shopcode \u5b57\u6bb5\uff0c\u65e0\u6cd5\u8ba1\u7b97 splitcode");
            return;
        }
        value = beanWrapper.getPropertyValue(shopIdField);
        if (value == null || !StringUtils.hasText((String)String.valueOf(value))) {
            ExceptionUtils.raise((String)(shopIdField + " \u5b57\u6bb5\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97 splitcode"));
        }
        if ((shopSplitConfig = this.shopSplitConfigService.getByShopId(shopid = String.valueOf(value))) == null || !StringUtils.hasText((String)shopSplitConfig.getSplitcode())) {
            ExceptionUtils.raise((String)(shopIdField + " " + shopid + " \u6ca1\u914d\u7f6e splitcode \u5bf9\u5e94\u5173\u7cfb"));
        }
        beanWrapper.setPropertyValue(splitCodeField, (Object)shopSplitConfig.getSplitcode());
    }

    @Override
    public void initUpdate(Object entity) {
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        String splitCodeField = "";
        for (String str : beanWrapper.getPropertiesSet()) {
            if (!this.splitcodeSet.contains(str.toLowerCase())) continue;
            splitCodeField = str;
            break;
        }
        if (StringUtils.hasText((String)splitCodeField)) {
            beanWrapper.setPropertyValue(splitCodeField, null);
        }
        super.initUpdate(entity);
    }
}

