/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.service.impl;

import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.msboot.clouds.RestBeanAccess;
import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.utils.ParamCheckUtil;
import com.efuture.msboot.core.utils.SpringContextHolder;
import com.efuture.msboot.data.DataAccess;
import com.efuture.msboot.data.ViewAccess;
import com.efuture.msboot.data.bean.CURDEnum;
import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.bean.Query;
import com.efuture.msboot.data.query.SqlBuilder;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.data.utils.EntityUtils;
import com.efuture.msboot.data.utils.ViewUtils;
import com.efuture.msboot.service.BaseListService;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class BaseListServiceImpl<T>
implements BaseListService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseListServiceImpl.class);
    @Lazy
    @Autowired(required=false)
    protected DataAccess dataAccess;
    @Lazy
    @Autowired(required=false)
    protected ViewAccess viewAccess;
    @Autowired
    protected SqlBuilder sqlBuilder;
    protected Class<T> beanClazz;
    protected Boolean supportRestBean = true;
    protected RestBeanAccess restBeanAccess;

    @PostConstruct
    public void init() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.beanClazz = (Class)type.getActualTypeArguments()[0];
    }

    @Override
    public T add(T entity) {
        Assert.notNull(entity, (String)"entry \u4e0d\u80fd\u4e3a\u7a7a");
        EntityUtils.initInsert(entity);
        this.dataAccess.insert(entity);
        Serializable id = EntityUtils.getIdValue(entity);
        return this.get(id);
    }

    @Override
    public T update(T entity) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        Serializable id = EntityUtils.getIdValue(entity);
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        EntityUtils.initUpdate(entity);
        this.dataAccess.updateById(entity);
        return this.get(id);
    }

    @Override
    public int delete(Serializable id) {
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return this.dataAccess.deleteById(id, this.beanClazz);
    }

    @Override
    public int deleteByMap(Map<String, Object> params) {
        Assert.notNull(params, (String)"params \u4e0d\u80fd\u4e3a\u7a7a");
        return this.dataAccess.deleteByMap(params, this.beanClazz);
    }

    @Override
    public int batchDelete(List<Serializable> ids) {
        return this.dataAccess.deleteBatchIds(ids, this.beanClazz);
    }

    @Override
    public int deleteByQuery(Query<T> query) {
        return this.dataAccess.delete(query, this.beanClazz);
    }

    @Override
    public List<Serializable> batchAdd(List<T> entityList) {
        return this.batchAdd(entityList, false);
    }

    @Override
    @Transactional
    public List<Serializable> batchAdd(List<T> entityList, Boolean validate) {
        Assert.notEmpty(entityList, (String)"entityList \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        for (T entity : entityList) {
            if (validate.booleanValue()) {
                ParamCheckUtil.validate(entity);
            }
            EntityUtils.initInsert(entity);
            this.dataAccess.insert(entity);
            ids.add(EntityUtils.getIdValue(entity));
        }
        return ids;
    }

    @Override
    @Transactional
    public List<T> save(List<T> entityList) {
        Assert.notEmpty(entityList, (String)"entityList \u4e0d\u80fd\u4e3a\u7a7a");
        for (T entity : entityList) {
            EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
            if (!beanWrapper.getPropertiesSet().contains("curd_flag")) continue;
            String curd_flag = EntityUtils.getCurdFlag(entity);
            if (!CURDEnum.DELETE.toString().equalsIgnoreCase(curd_flag)) continue;
            Serializable idValue = EntityUtils.getIdValue(entity);
            this.dataAccess.deleteById(idValue, entity.getClass());
        }
        for (T entity : entityList) {
            String curd_flag = EntityUtils.getCurdFlag(entity);
            if (CURDEnum.INSERT.toString().equalsIgnoreCase(curd_flag)) {
                EntityUtils.initInsert(entity);
                this.dataAccess.insert(entity);
                continue;
            }
            if (CURDEnum.UPDATE.toString().equalsIgnoreCase(curd_flag)) {
                EntityUtils.initUpdate(entity);
                this.dataAccess.updateById(entity);
                continue;
            }
            log.warn("\u65e0\u6cd5\u5904\u7406\u6807\u8bc6 " + curd_flag);
        }
        this.handleRestBean(entityList);
        return entityList;
    }

    @Override
    public T get(Serializable id) {
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        if (!ViewUtils.isView(this.beanClazz).booleanValue()) {
            return (T)this.dataAccess.selectById(id, this.beanClazz);
        }
        Object entity = this.viewAccess.selectById(id, this.beanClazz);
        this.handleRestBean(entity);
        return (T)entity;
    }

    @Override
    public boolean exist(Serializable id) {
        T entry = this.get(id);
        return entry != null;
    }

    @Override
    public DataPage<T> search(SearchInfo searchInfo) {
        if (searchInfo == null) {
            searchInfo = new SearchInfo();
        }
        searchInfo.setEntityClazz(this.beanClazz);
        String sqlTemplate = this.sqlBuilder.buildSqlTemplate(searchInfo);
        log.info(">>>> \n >> searchInfo: {}, \n >> sql: {}", (Object)searchInfo, (Object)sqlTemplate);
        DataPage dataPage = this.dataAccess.selectSqlPage(sqlTemplate, searchInfo.getParams(), searchInfo.getPageNo().intValue(), searchInfo.getPageSize().intValue(), this.beanClazz);
        this.handleRestBean(dataPage.getPageData());
        return dataPage;
    }

    @Override
    public List<T> listAll() {
        List result = this.dataAccess.selectList(new Query(), this.beanClazz);
        this.handleRestBean(result);
        return result;
    }

    @Override
    public List<T> listByMap(Map<String, Object> columnMap) {
        List resultList = this.dataAccess.selectByMap(columnMap, this.beanClazz);
        this.handleRestBean(resultList);
        return resultList;
    }

    @Override
    public List<T> listByIds(List<Serializable> ids) {
        List resultList = this.dataAccess.selectBatchIds(ids, this.beanClazz);
        this.handleRestBean(resultList);
        return resultList;
    }

    @Override
    public List<T> listByQuery(Query<T> query) {
        List resultList = this.dataAccess.selectList(query, this.beanClazz);
        this.handleRestBean(resultList);
        return resultList;
    }

    @Override
    public T getByMap(Map<String, Object> columnMap) {
        Object entity = this.dataAccess.selectOneByMap(columnMap, this.beanClazz);
        this.handleRestBean(entity);
        return (T)entity;
    }

    @Override
    public int countAll() {
        return this.dataAccess.selectCount(new Query(), this.beanClazz);
    }

    @Override
    public Map<String, T> dict(List<Map<String, Object>> paramsList) {
        if (CollectionUtils.isEmpty(paramsList)) {
            return null;
        }
        HashMap<String, T> dictMap = new HashMap<String, T>();
        for (Map<String, Object> params : paramsList) {
            StringBuilder sb = new StringBuilder();
            params.values().forEach(val -> sb.append(TypeUtils.castToString((Object)val)));
            String key = sb.toString();
            if (dictMap.containsKey(key)) continue;
            T entity = this.getByMap(params);
            dictMap.put(key, entity);
        }
        return dictMap;
    }

    protected void handleRestBean(Object obj) {
        if (!this.supportRestBean.booleanValue()) {
            return;
        }
        if (this.restBeanAccess == null) {
            Map map = SpringContextHolder.getApplicationContext().getBeansOfType(RestBeanAccess.class);
            if (CollectionUtils.isEmpty((Map)map)) {
                this.supportRestBean = false;
                return;
            }
            this.restBeanAccess = (RestBeanAccess)SpringContextHolder.getBean(RestBeanAccess.class);
        }
        this.restBeanAccess.handle(obj);
    }
}

