package com.efuture.msboot.exposer;

import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.service.BaseListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.Serializable;
import java.util.List;

public class BaseListExposer<S extends BaseListService<T>, T> {
    @Autowired
    protected S service;

    public DataPage<T> search(SearchInfo searchInfo){
        return service.search(searchInfo);
    }

    public T get(@RequestParam("id") Serializable id){
        return service.get(id);
    }

    public T add(T entity){
        return service.add(entity);
    }

    public T update(T entity){
        return service.update(entity);
    }

    public int delete(@RequestParam("id") Serializable id){
        return service.delete(id);
    }

    public int batchdelete(@RequestParam("ids") List<Serializable> ids){
        return service.batchDelete(ids);
    }
}
