package com.efuture.msboot.service;


import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.bean.Query;
import com.efuture.msboot.data.query.bean.SearchInfo;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by wzm on 2018/8/30.
 */
public interface BaseListService<T> {
    /**
     * 新增
     * @param entry
     * @return
     */
    T add(T entry);

    /**
     * 新增
     * @param entity
     * @param fleshGet true: 返回时从数据库获取； false: 返回缓存
     * @return
     */
    T add(T entity, Boolean fleshGet);

    /**
     * 更新
     * @param entry
     * @return
     */
    T update(T entry);

    /**
     * 更新
     * @param entry
     * @param fleshGet true: 返回时从数据库获取； false: 返回缓存
     * @return
     */
    T update(T entry, Boolean fleshGet);

    /**
     * 根据id删除
     * @param id
     * @return
     */
    int delete(Serializable id);

    /**
     * 根据id批量删除
     * @param ids
     */
    int batchDelete(List<Serializable> ids);

    /**
     * 根据query删除
     * @param query
     * @return
     */
    int deleteByQuery(Query<T> query);

    /**
     * 批量新增
     * @param entryList
     * @return 返回id列表
     */
    List<Serializable> batchAdd(List<T> entryList);

    /**
     * 批量新增
     * @param entryList
     * @param validate 是否校验字段
     * @return 返回id列表
     */
    List<Serializable> batchAdd(List<T> entryList, Boolean validate);

    /**
     * 批量保存
     * @param entityList
     * @return
     */
    List<T> save(List<T> entityList);

    /**
     * 根据id获取实体
     * @param id
     * @return
     */
    T get(Serializable id);

    /**
     * 判断id是否存在
     * @param id
     * @return
     */
    boolean exist(Serializable id);

    /**
     * 搜索
     * @param searchInfo
     * @return
     */
    DataPage<T> search(SearchInfo searchInfo);

    /**
     * 获取所有
     * @return
     */
    List<T> listAll();

    /**
     * 根据map获取
     * @param columnMap
     * @return
     */
    List<T> listByMap(Map<String,Object> columnMap);

    /**
     * 根据id获取
     * @param ids
     * @return
     */
    List<T> listByIds(List<Serializable> ids);

    /**
     * 根据id获取
     * @param query
     * @return
     */
    List<T> listByQuery(Query<T> query);

    /**
     * 根据map查询返回
     * @param columnMap
     * @return
     */
    T getByMap(Map<String, Object> columnMap);

    /**
     * 全部计数
     * @return
     */
    int countAll();
}
