package com.efuture.msboot.service.aop;

import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.service.annotation.Search;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * Created by wzm on 2019/4/9.
 */
@Aspect
@Component
@Order(0)
@Slf4j
public class SearchAop {
    @Pointcut("@annotation(com.efuture.msboot.service.annotation.Search)")
    public void searchHandle(){}

    @Before("searchHandle()")
    public void doBefore(JoinPoint joinPoint){
        Search search = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(Search.class);

        if(search == null){
            return;
        }

        Object[] args = joinPoint.getArgs();
        if(args == null){
            return;
        }

        SearchInfo searchInfo = null;

        for(Object obj:args){
            if(obj instanceof SearchInfo){
                searchInfo = (SearchInfo)obj;
                break;
            }
        }

        if(searchInfo == null){
            return;
        }

        Map<String, Object> params = searchInfo.getParams();
        boolean existConditionExpr = StringUtils.hasLength(searchInfo.getCondition());

        String[] conditonFieldDefine = search.conditonFieldDefine();
        for(String define:conditonFieldDefine){
            String[] record = define.split(":");
            if(record.length != 2){
                ExceptionUtils.raise("conditonFieldDefine 错误 "+define);
            }

            String orgiField = record[0].trim();
            String targetField = record[1].trim();

            if(existConditionExpr){
                String expr = searchInfo.getCondition();

                expr = expr.replace("${"+orgiField+"}", "${#}");
                expr = expr.replace(orgiField, targetField);
                expr = expr.replace("${#}", "${"+orgiField+"}");

                searchInfo.setCondition(expr);
            }else if(!CollectionUtils.isEmpty(params)){
                if(params.containsKey(orgiField)){
                    params.put(targetField, params.get(orgiField));
                    params.remove(orgiField);
                }
            }
        }
    }

    @After("searchHandle()")
    public void doAfter(){
    }
}
