package com.efuture.msboot.service.config;

import com.efuture.msboot.data.entity.EntityInitializer;
import com.efuture.msboot.service.aop.SearchAop;
import com.efuture.msboot.service.entity.DefaultEntityInitializer;
import com.efuture.msboot.service.entity.EntityPropertyDefine;
import com.efuture.msboot.service.sheet.SheetGlobalConfig;
import com.efuture.msboot.service.sheet.SheetIdGenerater;
import com.efuture.msboot.service.sheet.SheetUtils;
import com.efuture.msboot.service.sheet.impl.DefaultSheetIdGenerater;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by wzm on 2019/2/18.
 */
@Configuration
public class MsBootServiceConfig {

    @ConditionalOnMissingBean
    @Bean
    public EntityPropertyDefine entityPropertyDefine(){
        return new EntityPropertyDefine();
    }

    @ConditionalOnMissingBean
    @Bean
    public EntityInitializer entityInitializer(){
        return new DefaultEntityInitializer();
    }

    @ConditionalOnMissingBean
    @Bean
    public SheetGlobalConfig sheetGlobalConfig(){
        return new SheetGlobalConfig();
    }

    @Bean
    public SheetUtils sheetUtils(SheetGlobalConfig sheetGlobalConfig){
        return new SheetUtils(sheetGlobalConfig);
    }

    @ConditionalOnMissingBean(SheetIdGenerater.class)
    @Bean
    public SheetIdGenerater sheetIdGenerater(){
        return new DefaultSheetIdGenerater();
    }

    @ConditionalOnMissingBean
    @Bean
    public SearchAop searchAop(){
        return new SearchAop();
    }
}
