package com.efuture.msboot.service.entity;

import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.id.IdUtils;
import com.efuture.msboot.data.entity.EntityInitializer;
import com.efuture.msboot.data.utils.EntityUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * Created by wzm on 2019/2/18.
 */
@Slf4j
public class DefaultEntityInitializer implements EntityInitializer{

    @Autowired
    EntityPropertyDefine entityPropertyDefine;

    @Override
    public void initInsert(Object entity) {
        if(entity == null){
            return;
        }

        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);

        //如果存在id字段，并且不是组合id
        String idField = EntityUtils.getIdField(entity.getClass());
        if(StringUtils.hasText(idField) && !idField.contains(",")){
            beanWrapper.setPropertyValueIfNull(idField, IdUtils.newId());
        }

        //存在上下文
        SessionContext sessionContext = SessionContextHolder.get();
        if(sessionContext != null){
            //设置entid
            if(StringUtils.hasText(sessionContext.getEntId())){
                if(!CollectionUtils.isEmpty(entityPropertyDefine.getEntidProperties())){
                    for(String property:entityPropertyDefine.getEntidProperties()){
                        beanWrapper.setPropertyValueIfNull(property, sessionContext.getEntId());
                    }
                }
            }

            //设置创建人
            if(StringUtils.hasText(sessionContext.getUserName())){
                if(!CollectionUtils.isEmpty(entityPropertyDefine.getCreatorProperties())){
                    for(String property:entityPropertyDefine.getCreatorProperties()){
                        beanWrapper.setPropertyValueIfNull(property, sessionContext.getUserName());
                    }
                }
            }
        }

        //设置创建时间
        if(!CollectionUtils.isEmpty(entityPropertyDefine.getCreateTimeProperties())){
            for(String property:entityPropertyDefine.getCreateTimeProperties()){
                beanWrapper.setPropertyValueIfNull(property, new Date());
            }
        }
    }

    @Override
    public void initUpdate(Object entity) {
        if(entity == null){
            return;
        }

        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);

        //存在上下文
        SessionContext sessionContext = SessionContextHolder.get();
        if(sessionContext != null){
            //设置entid
            if(StringUtils.hasText(sessionContext.getEntId())){
                if(!CollectionUtils.isEmpty(entityPropertyDefine.getEntidProperties())){
                    for(String property:entityPropertyDefine.getEntidProperties()){
                        beanWrapper.setPropertyValueIfNull(property, sessionContext.getEntId());
                    }
                }
            }

            //设置修改人
            if(StringUtils.hasText(sessionContext.getUserName())){
                if(!CollectionUtils.isEmpty(entityPropertyDefine.getModifierProperties())){
                    for(String property:entityPropertyDefine.getModifierProperties()){
                        beanWrapper.setPropertyValueIfNull(property, sessionContext.getUserName());
                    }
                }
            }
        }

        //设置修改时间
        if(!CollectionUtils.isEmpty(entityPropertyDefine.getUpdateTimeProperties())){
            for(String property:entityPropertyDefine.getUpdateTimeProperties()){
                beanWrapper.setPropertyValueIfNull(property, new Date());
            }
        }
    }
}
