package com.efuture.msboot.service.impl;

import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.service.BatchCollectService;
import com.efuture.msboot.service.support.ActionResult;
import com.efuture.msboot.service.support.CollectAction;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

@Slf4j
public class BatchCollectServiceImpl implements BatchCollectService {
    @Value("${msboot.service.batchcollect.theads:10}")
    private Integer theadsCount;

    private ExecutorService threadPool;

    @PostConstruct
    public void init(){
        threadPool = Executors.newFixedThreadPool(theadsCount);
    }

    @Override
    public Map<String, Object> exec(List<CollectAction> taskList) {
        return exec(taskList, 0, TimeUnit.MILLISECONDS);
    }

    @Override
    public Map<String, Object> exec(List<CollectAction> taskList, long timeout, TimeUnit unit) {
        SessionContext sessionContext = SessionContextHolder.get();

        Map<String, Object> resultMap = new HashMap<>();
        List<Future<Object>> futureList = new ArrayList<>();

        for(CollectAction collectAction : taskList) {
            Future<Object> future = threadPool.submit(new Callable<Object>() {
                @Override
                public Object call() throws Exception {
                    try {
                        SessionContextHolder.put(sessionContext);

                        return collectAction.doAction();
                    }catch (Exception e){
                        return ActionResult.buildFail(e.getMessage());
                    }finally {
                        SessionContextHolder.remove();
                    }
                }
            });

            futureList.add(future);
        }

        for(Future<Object> future:futureList){
            try {
                ActionResult actionResult = timeout!=0? (ActionResult)future.get(timeout, unit): (ActionResult)future.get();
                if(!actionResult.isSuccess()){
                    ExceptionUtils.raise("执行批任务错误:"+actionResult.getMessage());
                }
                resultMap.put(actionResult.getKey(), actionResult.getValue());
            }catch (Exception e){
                log.error(e.getMessage(), e);
            }
        }

        return resultMap;
    }
}
