/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.service.entity;

import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.id.IdUtils;
import com.efuture.msboot.data.entity.EntityInitializer;
import com.efuture.msboot.data.utils.EntityUtils;
import com.efuture.msboot.service.entity.EntityPropertyDefine;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultEntityInitializer
implements EntityInitializer {
    private static final Logger log = LoggerFactory.getLogger(DefaultEntityInitializer.class);
    @Autowired
    EntityPropertyDefine entityPropertyDefine;

    public void initInsert(Object entity) {
        SessionContext sessionContext;
        if (entity == null) {
            return;
        }
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        String idField = EntityUtils.getIdField(entity.getClass());
        if (StringUtils.hasText((String)idField) && !idField.contains(",")) {
            beanWrapper.setPropertyValueIfNull(idField, (Object)IdUtils.newId());
        }
        if ((sessionContext = SessionContextHolder.get()) != null) {
            if (StringUtils.hasText((String)sessionContext.getEntId()) && !CollectionUtils.isEmpty(this.entityPropertyDefine.getEntidProperties())) {
                for (String property : this.entityPropertyDefine.getEntidProperties()) {
                    beanWrapper.setPropertyValueIfNull(property, (Object)sessionContext.getEntId());
                }
            }
            if (StringUtils.hasText((String)sessionContext.getUserName()) && !CollectionUtils.isEmpty(this.entityPropertyDefine.getCreatorProperties())) {
                for (String property : this.entityPropertyDefine.getCreatorProperties()) {
                    beanWrapper.setPropertyValueIfNull(property, (Object)sessionContext.getUserName());
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.entityPropertyDefine.getCreateTimeProperties())) {
            for (String property : this.entityPropertyDefine.getCreateTimeProperties()) {
                beanWrapper.setPropertyValueIfNull(property, (Object)new Date());
            }
        }
    }

    public void initUpdate(Object entity) {
        if (entity == null) {
            return;
        }
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        SessionContext sessionContext = SessionContextHolder.get();
        if (sessionContext != null) {
            if (StringUtils.hasText((String)sessionContext.getEntId()) && !CollectionUtils.isEmpty(this.entityPropertyDefine.getEntidProperties())) {
                for (String property : this.entityPropertyDefine.getEntidProperties()) {
                    beanWrapper.setPropertyValueIfNull(property, (Object)sessionContext.getEntId());
                }
            }
            if (StringUtils.hasText((String)sessionContext.getUserName()) && !CollectionUtils.isEmpty(this.entityPropertyDefine.getModifierProperties())) {
                for (String property : this.entityPropertyDefine.getModifierProperties()) {
                    beanWrapper.setPropertyValueIfNull(property, (Object)sessionContext.getUserName());
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.entityPropertyDefine.getUpdateTimeProperties())) {
            for (String property : this.entityPropertyDefine.getUpdateTimeProperties()) {
                beanWrapper.setPropertyValueIfNull(property, (Object)new Date());
            }
        }
    }
}

