/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.service.impl;

import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.core.utils.ParamCheckUtil;
import com.efuture.msboot.data.DataAccess;
import com.efuture.msboot.data.ViewAccess;
import com.efuture.msboot.data.bean.CURDEnum;
import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.bean.Query;
import com.efuture.msboot.data.query.SqlBuilder;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.data.utils.EntityUtils;
import com.efuture.msboot.data.utils.SearchUtils;
import com.efuture.msboot.data.utils.ViewUtils;
import com.efuture.msboot.service.BaseListService;
import com.efuture.msboot.service.annotation.Search;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public abstract class BaseListServiceImpl<T>
implements BaseListService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseListServiceImpl.class);
    @Lazy
    @Autowired(required=false)
    protected DataAccess dataAccess;
    @Lazy
    @Autowired(required=false)
    protected ViewAccess viewAccess;
    @Autowired
    protected SqlBuilder sqlBuilder;
    protected Class<T> beanClazz;
    protected Search searchAnnotation;

    @PostConstruct
    public void init() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.beanClazz = (Class)type.getActualTypeArguments()[0];
        this.searchAnnotation = this.getClass().getAnnotation(Search.class);
    }

    @Override
    public T add(T entity) {
        return this.add(entity, true);
    }

    @Override
    public T add(T entity, Boolean fleshGet) {
        Assert.notNull(entity, (String)"entry \u4e0d\u80fd\u4e3a\u7a7a");
        EntityUtils.initInsert(entity);
        this.dataAccess.insert(entity);
        Serializable id = EntityUtils.getIdValue(entity);
        return fleshGet != false ? this.get(id) : entity;
    }

    @Override
    public T update(T entity) {
        return this.update(entity, true);
    }

    @Override
    public T update(T entity, Boolean fleshGet) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        Serializable id = EntityUtils.getIdValue(entity);
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        EntityUtils.initUpdate(entity);
        this.dataAccess.updateById(entity);
        return fleshGet != false ? this.get(id) : entity;
    }

    @Override
    public int delete(Serializable id) {
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return this.dataAccess.deleteById(id, this.beanClazz);
    }

    @Override
    public int batchDelete(List<Serializable> ids) {
        return this.dataAccess.deleteBatchIds(ids, this.beanClazz);
    }

    @Override
    public int deleteByQuery(Query<T> query) {
        return this.dataAccess.delete(query, this.beanClazz);
    }

    @Override
    public List<Serializable> batchAdd(List<T> entityList) {
        return this.batchAdd(entityList, false);
    }

    @Override
    @Transactional
    public List<Serializable> batchAdd(List<T> entityList, Boolean validate) {
        Assert.notEmpty(entityList, (String)"entityList \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        for (T entity : entityList) {
            if (validate.booleanValue()) {
                ParamCheckUtil.validate(entity);
            }
            EntityUtils.initInsert(entity);
            this.dataAccess.insert(entity);
            ids.add(EntityUtils.getIdValue(entity));
        }
        return ids;
    }

    @Override
    @Transactional
    public List<T> save(List<T> entityList) {
        Assert.notEmpty(entityList, (String)"entityList \u4e0d\u80fd\u4e3a\u7a7a");
        for (T entity : entityList) {
            EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
            if (!beanWrapper.getPropertiesSet().contains("curd_flag")) continue;
            String curd_flag = EntityUtils.getCurdFlag(entity);
            if (!CURDEnum.DELETE.toString().equalsIgnoreCase(curd_flag)) continue;
            Serializable idValue = EntityUtils.getIdValue(entity);
            this.dataAccess.deleteById(idValue, entity.getClass());
        }
        for (T entity : entityList) {
            String curd_flag = EntityUtils.getCurdFlag(entity);
            if (CURDEnum.INSERT.toString().equalsIgnoreCase(curd_flag)) {
                EntityUtils.initInsert(entity);
                this.dataAccess.insert(entity);
                continue;
            }
            if (CURDEnum.UPDATE.toString().equalsIgnoreCase(curd_flag)) {
                EntityUtils.initUpdate(entity);
                this.dataAccess.updateById(entity);
                continue;
            }
            log.warn("\u65e0\u6cd5\u5904\u7406\u6807\u8bc6 " + curd_flag);
        }
        return entityList;
    }

    @Override
    public T get(Serializable id) {
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        if (!ViewUtils.isView(this.beanClazz).booleanValue()) {
            return (T)this.dataAccess.selectById(id, this.beanClazz);
        }
        return (T)this.viewAccess.selectById(id, this.beanClazz);
    }

    @Override
    public boolean exist(Serializable id) {
        T entry = this.get(id);
        return entry != null;
    }

    @Override
    public DataPage<T> search(SearchInfo searchInfo) {
        if (searchInfo == null) {
            searchInfo = new SearchInfo();
        }
        searchInfo.setEntityClazz(this.beanClazz);
        String sqlTemplate = this.sqlBuilder.buildSqlTemplate(searchInfo);
        log.info(">>>> \n >> searchInfo: {}, \n >> sql: {}", (Object)searchInfo, (Object)sqlTemplate);
        return this.dataAccess.selectSqlPage(sqlTemplate, searchInfo.getParams(), searchInfo.getPageNo().intValue(), searchInfo.getPageSize().intValue(), this.beanClazz);
    }

    @Override
    public List<T> listAll() {
        return this.dataAccess.selectList(new Query(), this.beanClazz);
    }

    @Override
    public List<T> listByMap(Map<String, Object> columnMap) {
        return this.dataAccess.selectByMap(columnMap, this.beanClazz);
    }

    @Override
    public List<T> listByIds(List<Serializable> ids) {
        return this.dataAccess.selectBatchIds(ids, this.beanClazz);
    }

    @Override
    public List<T> listByQuery(Query<T> query) {
        return this.dataAccess.selectList(query, this.beanClazz);
    }

    @Override
    public T getByMap(Map<String, Object> columnMap) {
        return (T)this.dataAccess.selectOneByMap(columnMap, this.beanClazz);
    }

    @Override
    public int countAll() {
        return this.dataAccess.selectCount(new Query(), this.beanClazz);
    }

    private void checkSearchRef(SearchInfo searchInfo) {
        if (this.searchAnnotation == null) {
            ExceptionUtils.raise((String)"\u672a\u914d\u7f6esearch\u63a5\u53e3");
        }
        if (this.searchAnnotation.refs() == null || this.searchAnnotation.refs().length == 0) {
            ExceptionUtils.raise((String)"\u672a\u914d\u7f6esearch.refs\u63a5\u53e3");
        }
        SearchUtils.checkSearchRef((SearchInfo)searchInfo, Arrays.asList(this.searchAnnotation.refs()));
    }

    private Object newBeanOject() {
        try {
            return this.beanClazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

