package com.efuture.msboot.token.config;

import com.efuture.msboot.session.SessionContextBuilder;
import com.efuture.msboot.token.exposer.TokenExposer;
import com.efuture.msboot.token.service.TokenCacheService;
import com.efuture.msboot.token.service.TokenService;
import com.efuture.msboot.token.service.UserService;
import com.efuture.msboot.token.service.impl.*;
import com.efuture.msboot.token.session.TokenSessionContextBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * Created by wzm on 2019/6/27.
 */
@Configuration
@EnableConfigurationProperties({MsBootTokenConfigurationProperties.class})
@ConditionalOnProperty(prefix = "msboot.token", name = "enable", havingValue = "true")
public class MsBootToken2Config {
    @Autowired
    MsBootTokenConfigurationProperties msBootTokenConfigurationProperties;

    @Bean("auth.token")
    public TokenExposer tokenExposer(){
        return new TokenExposer();
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenService tokenService(){
        return new TokenServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public UserService userService(){
        if("db".equalsIgnoreCase(msBootTokenConfigurationProperties.getUserService().getType())) {
            return new UserServiceImpl();
        }
        return new LocalUserServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenCacheService tokenCacheService(){
        if( "redis".equalsIgnoreCase(msBootTokenConfigurationProperties.getCacheType())){
            return new RedisTokenCacheServiceImpl();
        }
        return new LocalTokenCacheServiceImpl();
    }

    @Bean
    @Primary
    public SessionContextBuilder sessionContextBuilder(){
        return new TokenSessionContextBuilder();
    }
}
