package com.efuture.msboot.token.exposer;

import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.token.bean.TokenInfo;
import com.efuture.msboot.token.bean.UserInfo;
import com.efuture.msboot.token.service.TokenService;
import com.efuture.msboot.token.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Created by wzm on 2019/6/27.
 */
public class TokenExposer {
    @Autowired
    UserService userService;

    @Autowired
    TokenService tokenService;

    public TokenInfo create(@RequestParam("usercode") String usercode,
                            @RequestParam("password") String password){
        UserInfo userInfo = userService.login(usercode, password, null);
        if(userInfo == null){
            ExceptionUtils.raise("用户或密码 错误");
        }

        return tokenService.create(userInfo);
    }

    public TokenInfo get(){
        return tokenService.get(SessionContextHolder.get().getToken());
    }
}
