package com.efuture.msboot.token.service.impl;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.embedded.LinkedHashMapCacheBuilder;
import com.efuture.msboot.token.service.TokenCacheService;

import javax.annotation.PostConstruct;
import java.util.concurrent.TimeUnit;

/**
 * Created by wzm on 2019/6/27.
 */
public class LocalTokenCacheServiceImpl implements TokenCacheService{
    Cache<String,Object> localCache;

    @PostConstruct
    public void init(){
        this.localCache = LinkedHashMapCacheBuilder.createLinkedHashMapCacheBuilder().buildCache();
    }

    @Override
    public void put(String key, Object value, Long expires, TimeUnit timeUnit) {
        localCache.put(key, value, expires, TimeUnit.HOURS);
    }

    @Override
    public Object get(String key) {
        return localCache.get(key);
    }
}
