package com.efuture.msboot.token.service.impl;

import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.token.bean.UserInfo;
import com.efuture.msboot.token.service.UserService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

import java.util.HashMap;
import java.util.Map;

public class LocalUserServiceImpl implements UserService , InitializingBean {
    @Value("${msboot.token.userService.userpassword:admin:admin}")
    private String userpassword;

    private Map<String,String> userPasswordMap;

    @Override
    public UserInfo login(String code, String password, String entcode) {
        if(!userPasswordMap.containsKey(code) || !userPasswordMap.get(code).equalsIgnoreCase(password)){
            ExceptionUtils.raise("用户或密码错误");
        }

        UserInfo userInfo = new UserInfo();
        userInfo.setUserid(TypeUtils.castToLong(code.hashCode()));
        userInfo.setUsercode(code);
        userInfo.setUsername(code);

        return userInfo;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.userPasswordMap = new HashMap<>();

        for(String rs:userpassword.split(",")) {
            String[] pair = rs.split(":");
            String user = pair[0].trim();
            String password = pair.length>1?pair[1].trim():user;

            this.userPasswordMap.put(user, password);
        }
    }
}
