package com.efuture.msboot.token.service.impl;

import com.efuture.msboot.token.service.TokenCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.concurrent.TimeUnit;

public class RedisTokenCacheServiceImpl implements TokenCacheService {
    @Autowired
    RedisTemplate<String,Object> redisTemplate;

    @Override
    public void put(String key, Object value, Long expires, TimeUnit timeUnit) {
        redisTemplate.opsForValue().set(key, value, expires, timeUnit);
    }

    @Override
    public Object get(String key) {
        return redisTemplate.opsForValue().get(key);
    }
}
