package com.efuture.msboot.token.service.impl;

import com.efuture.msboot.token.bean.TokenInfo;
import com.efuture.msboot.token.bean.UserInfo;
import com.efuture.msboot.token.service.TokenCacheService;
import com.efuture.msboot.token.service.TokenService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * Created by wzm on 2019/6/27.
 */
public class TokenServiceImpl implements TokenService{
    @Autowired
    TokenCacheService tokenCacheService;

    final static String tokenPrefix = "msbtoken:";

    @Override
    public TokenInfo create(UserInfo userInfo) {
        String uuid = UUID.randomUUID().toString();

        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setAccess_token(uuid);
        tokenInfo.setUser_id(String.valueOf(userInfo.getUserid()));
        tokenInfo.setUser_name(userInfo.getUsername());
        tokenInfo.setUser_code(userInfo.getUsercode());

        tokenCacheService.put(tokenPrefix+uuid, tokenInfo, 24L, TimeUnit.HOURS);

        return tokenInfo;
    }

    @Override
    public TokenInfo get(String token) {
        return (TokenInfo)tokenCacheService.get(tokenPrefix+token);
    }
}
