package com.efuture.msboot.token.service.impl;

import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.DataAccess;
import com.efuture.msboot.token.bean.UserInfo;
import com.efuture.msboot.token.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * Created by wzm on 2019/6/27.
 */
@Slf4j
public class UserServiceImpl implements UserService, InitializingBean{
    @Value("${msboot.token.loadUserSql:null}")
    private String loadUserSql;

    @Autowired
    private DataAccess dataAccess;

    @Override
    public UserInfo login(String code, String password, String entcode) {
        String selSql = loadUserSql.replace("?", "'" + code + "'");

        List<UserInfo> msbUserList = this.dataAccess.selectSqlList(selSql, UserInfo.class);
        if(CollectionUtils.isEmpty(msbUserList)){
            log.error("用户不存在 {}", code);
            ExceptionUtils.raise("用户或密码错误");
        }

        UserInfo userInfo = msbUserList.get(0);
        if(!password.equalsIgnoreCase(userInfo.getPassword())){
            log.error("用户密码错误 {} {}", code, password);
            ExceptionUtils.raise("用户或密码错误");
        }

        return userInfo;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if(!StringUtils.hasText(loadUserSql) || loadUserSql.equals("null")){
            loadUserSql = "select id as userid, code as usercode, name as username, password from msb_user where code = ?";
        }
    }
}
