package com.efuture.msboot.token.session;

import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.impl.SessionContextImpl;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.session.impl.DefaultSessionContextBuilder;
import com.efuture.msboot.token.bean.TokenInfo;
import com.efuture.msboot.token.service.TokenService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by wzm on 2019/6/27.
 */
@Slf4j
public class TokenSessionContextBuilder extends DefaultSessionContextBuilder {
    @Autowired
    TokenService tokenService;

    @Override
    public SessionContext build(String ent_id, String user_id, String user_code, String user_name, String locale, String session, String token, Object... exts) {
        String method = getMethod();
        SessionContext sessionContext = null;

        if(!method.startsWith("auth.token")){
            if(!StringUtils.hasText(token)) {
                ExceptionUtils.raise("invalid param: token");
            }

            sessionContext = tryBuildFromToken(token);
        }else{
            sessionContext = super.build(ent_id, user_id, user_code, user_name, locale, session, token);
        }

        return sessionContext;
    }

    private SessionContext tryBuildFromToken(String token) {
        TokenInfo tokenInfo = tokenService.get(token);
        if(tokenInfo == null){
            ExceptionUtils.raise("invalid token");
        }

        SessionContextImpl sessionContext = new SessionContextImpl(
                tokenInfo.getEnt_id(), tokenInfo.getEnt_code(), null,
                tokenInfo.getUser_id(), tokenInfo.getUser_code(), tokenInfo.getUser_name(), null, null, null);

        return sessionContext;
    }

    private String getMethod(){
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();

        String method = request.getParameter("method");
        return method;
    }
}
