/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocm.common.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocm.common.component.BaseServiceIntf;
import com.efuture.ocm.common.component.BasicComponent;
import com.efuture.ocm.common.entity.AbstractEntityBean;
import com.efuture.ocm.common.entity.ServiceResponse;
import com.efuture.ocm.common.entity.ServiceSession;
import com.efuture.ocm.common.exception.ServiceException;
import com.efuture.ocm.common.language.MessageSourceHelper;
import com.efuture.ocm.common.util.StorageUtils;
import com.efuture.ocm.common.util.UniqueID;
import com.efuture.omd.storage.FStorageOperations;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class BasicComponentService<T extends AbstractEntityBean>
extends BasicComponent
implements BaseServiceIntf {
    static final String PARENT_ID_KEY = "parent_id";
    final Class<T> beanClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), BasicComponentService.class);

    protected Class<T> getBeanClass() {
        return this.beanClass;
    }

    protected String getBeanTable() {
        return AbstractEntityBean.fetchAnnotationTableName(this.getBeanClass());
    }

    protected String getIdKey() throws IllegalArgumentException, IllegalAccessException {
        return this.getIdKey(null);
    }

    protected String getIdKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        return (String)AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "ID_KEY").get(null);
    }

    protected String[] getUniqueKeys() throws IllegalArgumentException, IllegalAccessException {
        return this.getUniqueKeys(null);
    }

    protected String[] getUniqueKeys(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "UNIQUE_KEYS");
        if (fld == null) {
            return null;
        }
        return (String[])fld.get(null);
    }

    protected Map<String, Object> getDependency(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "DEPENDENCY");
        if (fld == null) {
            return null;
        }
        return (Map)fld.get(null);
    }

    protected Field getIdField() throws IllegalArgumentException, IllegalAccessException {
        Field idfld = AbstractEntityBean.fetchDeclaredField(this.getBeanClass(), this.getIdKey());
        return idfld;
    }

    protected void checkDependency(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys) throws Exception {
        if (storage == null) {
            return;
        }
        Map<String, Object> dependencys = this.getDependency(bean.getClass());
        if (dependencys == null) {
            return;
        }
        Set<String> depkeys = dependencys.keySet();
        for (String key : depkeys) {
            Field codefld;
            String codekey;
            Map depbean;
            Field depfld;
            Object depval;
            Object depobj = dependencys.get(key);
            if (depobj == null || keys != null && !keys.contains(key) || StringUtils.isEmpty((Object)(depval = (depfld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), key)).get(bean)))) continue;
            if ((depval instanceof Long || depval instanceof Integer) && Long.parseLong(depval.toString()) <= 0L) {
                depfld.set(bean, 0);
                continue;
            }
            String deptable = null;
            String idkey = null;
            String[] ohkey = null;
            if (depobj instanceof String) {
                String[] ss = ((String)depobj).split(":");
                if (ss.length > 0) {
                    deptable = ss[0].trim();
                }
                if (ss.length > 1) {
                    ohkey = ss[1].split(",");
                    idkey = ohkey[0].trim();
                }
            } else if (depobj instanceof Class) {
                idkey = (String)AbstractEntityBean.fetchDeclaredField((Class)depobj, "ID_KEY").get(null);
                deptable = AbstractEntityBean.fetchAnnotationTableName((Class)depobj);
            }
            if (StringUtils.isEmpty(idkey)) {
                throw new ServiceException("10005", "{0} 's dependency {1} is illegal key in {2}", key, idkey, MessageSourceHelper.getMessage(deptable, bean.getLang(), new Object[0]));
            }
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(idkey).is(depval);
            if (ohkey != null && ohkey.length > 1) {
                for (int i = 1; i < ohkey.length; ++i) {
                    String[] ss = ohkey[i].split("=");
                    if (ss.length <= 1) continue;
                    criteria = criteria.and(ss[0].trim()).is((Object)ss[1].trim());
                }
            }
            Query query = new Query(criteria);
            query.fields().include(idkey);
            if (key.endsWith("_id")) {
                query.fields().include("code");
                query.fields().include("name");
            }
            if ((depbean = storage.selectOne(query, deptable)) == null) {
                throw new ServiceException("10006", "{0} [{1}] does not exist with {2} of {3}", key, depval, idkey, MessageSourceHelper.getMessage(deptable, bean.getLang(), new Object[0]));
            }
            if (!key.endsWith("_id")) continue;
            if (!StringUtils.isEmpty(depbean.get("code"))) {
                codekey = key.replace("_id", "_code");
                codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
                if (codefld != null) {
                    codefld.set(bean, depbean.get("code"));
                    if (keys != null && !keys.contains(codekey)) {
                        keys.add(codekey);
                    }
                }
            }
            if (StringUtils.isEmpty(depbean.get("name"))) continue;
            codekey = key.replace("_id", "_name");
            codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
            if (codefld != null) {
                codefld.set(bean, depbean.get("name"));
                if (keys == null || keys.contains(codekey)) continue;
                keys.add(codekey);
                continue;
            }
            codekey = key.replace("_id", "");
            codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
            if (codefld == null) continue;
            codefld.set(bean, depbean.get("name"));
            if (keys == null || keys.contains(codekey)) continue;
            keys.add(codekey);
        }
    }

    protected boolean haveParentDependency() throws IllegalArgumentException, IllegalAccessException {
        Map<String, Object> dependencys = this.getDependency(null);
        return dependencys != null && dependencys.keySet().contains(PARENT_ID_KEY);
    }

    @Override
    protected void onAddValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        super.onAddValid(storage, bean, id, uniques);
        this.checkDependency(storage, bean, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse add(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass());
            this.getIdField().set(bean, UniqueID.getUniqueID());
            bean.initInsertMember(session);
            String idkey = this.getIdKey();
            long id = this.doAdd(bean, idkey, this.getUniqueKeys());
            this.updateIsParent(bean);
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, (Object)id);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    protected AbstractEntityBean onUpdateValid(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        AbstractEntityBean original = super.onUpdateValid(storage, bean, keys, id, uniques);
        this.checkDependency(storage, bean, keys);
        return original;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse update(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass());
            bean.initUpdateMember(session);
            HashSet<String> keys = new HashSet<String>(JSON.parseObject((String)param).keySet());
            String idkey = this.getIdKey();
            long id = 0L;
            if (this.haveParentDependency() && keys.contains(PARENT_ID_KEY)) {
                AbstractEntityBean original = this.execUpdate(bean, keys, idkey, this.getUniqueKeys());
                this.updateIsParent(bean);
                if (original != null) {
                    this.updateIsParent(original);
                    Field fld = bean.fetchDeclaredField(idkey);
                    id = fld.getLong(original);
                }
            } else {
                id = this.doUpdate(bean, keys, idkey, this.getUniqueKeys());
            }
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, (Object)id);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    public AbstractEntityBean onDeleteValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... keys) throws Exception {
        AbstractEntityBean original = super.onDeleteValid(storage, bean, id, keys);
        if (storage != null) {
            Map<String, Object> dependencys = this.getDependency(bean.getClass());
            if (dependencys == null || !dependencys.keySet().contains(PARENT_ID_KEY)) {
                return original;
            }
            if (original != null) {
                Field idfld = bean.fetchDeclaredField(id);
                if (bean.fetchDeclaredField("is_parent").getBoolean(original)) {
                    throw new ServiceException("10007", "{0} {1} [{2}] is parent,can not delete", MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang(), new Object[0]), id, idfld.get(bean));
                }
            }
        }
        return original;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse delete(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass());
            bean.initUpdateMember(session);
            String idkey = this.getIdKey();
            long id = 0L;
            if (this.haveParentDependency()) {
                AbstractEntityBean original = this.execDelete(bean, idkey, new String[0]);
                if (original != null) {
                    this.updateIsParent(original);
                    Field fld = bean.fetchDeclaredField(idkey);
                    id = fld.getLong(original);
                }
            } else {
                id = this.doDelete(bean, idkey, new String[0]);
            }
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, (Object)id);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    protected void updateIsParent(AbstractEntityBean bean) throws Exception {
        String idkey = this.getIdKey();
        if (!this.haveParentDependency()) {
            return;
        }
        Object parent_id = bean.fetchDeclaredField(PARENT_ID_KEY).get(bean);
        if ((parent_id instanceof Long || parent_id instanceof Integer) && Long.parseLong(parent_id.toString()) <= 0L) {
            return;
        }
        if (parent_id instanceof String && StringUtils.isEmpty((Object)parent_id)) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)bean.getEnt_id());
        json.put(PARENT_ID_KEY, parent_id);
        AbstractEntityBean childbean = (AbstractEntityBean)this.doSearchOne(json, this.getBeanClass());
        json.clear();
        json.put("ent_id", (Object)bean.getEnt_id());
        json.put(idkey, parent_id);
        json.put("is_parent", (Object)(childbean != null ? 1 : 0));
        this.doUpdate((AbstractEntityBean)JSON.toJavaObject((JSON)json, this.getBeanClass()), json.keySet(), idkey, new String[0]);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse save(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            JSONArray jsonarray = null;
            Object obj = JSON.parse((String)param);
            if (obj instanceof JSONArray) {
                jsonarray = (JSONArray)obj;
            } else if (obj instanceof JSONObject && (jsonarray = ((JSONObject)obj).getJSONArray(this.getBeanTable())) == null) {
                jsonarray = new JSONArray();
                jsonarray.add(obj);
            }
            if (jsonarray == null) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            JSONArray returnarray = this.doSave(session, jsonarray);
            return ServiceResponse.buildSuccess(returnarray);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception {
        JSONArray returnarray = new JSONArray();
        String flag = "flag";
        String idkey = this.getIdKey();
        for (int i = 0; i < jsonarray.size(); ++i) {
            JSONObject json = jsonarray.getJSONObject(i);
            if (!json.containsKey((Object)flag)) {
                returnarray.add(null);
                continue;
            }
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(json, this.getBeanClass());
            if ("I".equalsIgnoreCase(json.getString(flag))) {
                this.getIdField().set(bean, UniqueID.getUniqueID());
                bean.initInsertMember(session);
                returnarray.add((Object)this.doAdd(bean, idkey, this.getUniqueKeys()));
                continue;
            }
            if ("U".equalsIgnoreCase(json.getString(flag))) {
                bean.initUpdateMember(session);
                returnarray.add((Object)this.doUpdate(bean, json.keySet(), idkey, this.getUniqueKeys()));
                continue;
            }
            if (!"D".equalsIgnoreCase(json.getString(flag))) continue;
            bean.initUpdateMember(session);
            returnarray.add((Object)this.doDelete(bean, idkey, new String[0]));
        }
        return returnarray;
    }

    @Override
    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            if (!jsonparam.containsKey((Object)idkey) || StringUtils.isEmpty((Object)jsonparam.get((Object)idkey))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            Map<String, Object> obj = null;
            obj = !jsonparam.containsKey((Object)"fields") ? (Map<String, Object>)this.doSearchOne(jsonparam, this.getBeanClass()) : this.doSearchOneForMap(jsonparam, this.getBeanClass());
            if (obj == null) {
                return ServiceResponse.buildFailure(session, "10003", "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));
            }
            JSONObject respdata = new JSONObject();
            respdata.put(table, obj);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    public ServiceResponse search(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            StringBuffer total = new StringBuffer();
            List<Object> list = null;
            list = !jsonparam.containsKey((Object)"fields") ? this.doSearch(jsonparam, this.getBeanClass(), total) : this.doSearchForMap(jsonparam, this.getBeanClass(), total);
            JSONObject respdata = new JSONObject();
            respdata.put("total_results", (Object)Long.parseLong(total.toString()));
            respdata.put(this.getBeanTable(), list);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    public ServiceResponse getchildren(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            if (!jsonparam.containsKey((Object)idkey) || StringUtils.isEmpty((Object)jsonparam.get((Object)idkey))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            jsonparam.put(PARENT_ID_KEY, jsonparam.get((Object)idkey));
            jsonparam.remove((Object)idkey);
            List<Object> list = null;
            list = !jsonparam.containsKey((Object)"fields") ? this.doSearch(jsonparam, this.getBeanClass(), null) : this.doSearchForMap(jsonparam, this.getBeanClass(), null);
            JSONObject respdata = new JSONObject();
            respdata.put(table, list);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    public Object export(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            if (!jsonparam.containsKey((Object)"fields") || StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", this.getBeanTable(), "fields");
            }
            String[] fields = jsonparam.getString("fields").split(",");
            StringBuffer flds = new StringBuffer();
            ArrayList<String> fldlst = new ArrayList<String>();
            HashMap<String, String> disps = new HashMap<String, String>();
            HashMap<String, String> fmts = new HashMap<String, String>();
            for (String s : fields) {
                String[] stringArray = s.split(":");
                flds.append(stringArray[0].trim() + ",");
                fldlst.add(stringArray[0].trim());
                if (stringArray.length > 1) {
                    disps.put(stringArray[0].trim(), stringArray[1].trim());
                    if (stringArray.length <= 2) continue;
                    fmts.put(stringArray[0].trim(), stringArray[2].trim().replace(";", ","));
                    continue;
                }
                disps.put(stringArray[0].trim(), stringArray[0].trim());
            }
            jsonparam.put("fields", (Object)flds.toString());
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            StringBuffer total = null;
            if (jsonparam.containsKey((Object)"page_size") && jsonparam.getInteger("page_size") < 0 || jsonparam.containsKey((Object)"page_no") && jsonparam.getInteger("page_no") < 0) {
                jsonparam.remove((Object)"page_size");
                jsonparam.remove((Object)"page_no");
            } else {
                total = new StringBuffer();
            }
            List<Map<String, Object>> list = this.doSearchForMap(jsonparam, this.getBeanClass(), total);
            StringBuffer sb = new StringBuffer();
            sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\r\n");
            sb.append("<table cellspacing=\"0\" cellpadding=\"5\" rules=\"all\" border=\"1\">\r\n");
            sb.append("<tr style=\"font-weight: bold; color:red; white-space: nowrap;\">\r\n");
            for (String string : fldlst) {
                sb.append(String.format("<td>%1$s</td>\r\n", disps.get(string)));
            }
            sb.append("</tr>\r\n");
            for (Map map : list) {
                sb.append("<tr>\r\n");
                for (String s : fldlst) {
                    Object obj = map.get(s);
                    if (obj == null) {
                        sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:@\">%1$s</td>\r\n", ""));
                        continue;
                    }
                    String style = (String)fmts.get(s);
                    if (obj instanceof Date) {
                        if (StringUtils.isEmpty((Object)style)) {
                            style = "yyyy-mm-dd";
                        }
                        long date = ((Date)obj).getTime() / 86400000L + 25569L;
                        sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", date));
                        continue;
                    }
                    if (StringUtils.isEmpty((Object)style)) {
                        style = obj instanceof Integer || obj instanceof Long || obj instanceof Short ? "0" : (obj instanceof Double || obj instanceof Float ? "#,##0.00" : "@");
                    }
                    sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", obj));
                }
                sb.append("</tr>\r\n");
            }
            sb.append("</table>\r\n");
            return sb.toString();
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }
}

