/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocm.common.entity;

import com.efuture.ocm.common.entity.ServiceSession;
import com.efuture.ocm.common.exception.BeanValidateException;
import com.efuture.ocm.common.language.MessageSourceHelper;
import com.efuture.ocm.common.util.ValidatorUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

public abstract class AbstractEntityBean
implements Serializable {
    private static final long serialVersionUID = -61572915813771273L;
    protected long ent_id;
    @Transient
    protected String status = "1";
    @Transient
    protected String lang;
    @Transient
    protected Date timestamp;
    @Transient
    protected String note;
    @Transient
    protected long creator_id;
    @Transient
    protected String creator;
    @Transient
    protected long modifier_id;
    @Transient
    protected String modifier;

    public long getEnt_id() {
        return this.ent_id;
    }

    public void setEnt_id(long ent_id) {
        this.ent_id = ent_id;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public long getCreator_id() {
        return this.creator_id;
    }

    public void setCreator_id(long creator_id) {
        this.creator_id = creator_id;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public long getModifier_id() {
        return this.modifier_id;
    }

    public void setModifier_id(long modifier_id) {
        this.modifier_id = modifier_id;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void initInsertMember(ServiceSession session) {
        this.setEnt_id(session.getEnt_id());
        this.setCreator_id(session.getUser_id());
        this.setCreator(session.getUser_name());
        this.setTimestamp(new Date());
        this.setStatus("1");
        this.setLang(session.getLocale());
    }

    public void initInsertMember(AbstractEntityBean bean) {
        this.setEnt_id(bean.getEnt_id());
        this.setCreator_id(bean.getCreator_id());
        this.setCreator(bean.getCreator());
        this.setTimestamp(new Date());
        this.setStatus("1");
        this.setLang(bean.getLang());
    }

    public void initUpdateMember(ServiceSession session) {
        this.setEnt_id(session.getEnt_id());
        this.setModifier_id(session.getUser_id());
        this.setModifier(session.getUser_name());
        this.setTimestamp(new Date());
        this.setLang(session.getLocale());
    }

    public void initUpdateMember(AbstractEntityBean bean) {
        this.setEnt_id(bean.getEnt_id());
        this.setModifier_id(bean.getModifier_id());
        this.setModifier(bean.getModifier());
        this.setTimestamp(new Date());
        this.setLang(bean.getLang());
    }

    public String fetchAnnotationTableName() {
        return AbstractEntityBean.fetchAnnotationTableName(this.getClass());
    }

    public static String fetchAnnotationTableName(Class<?> cl) {
        Annotation[] annos;
        for (Annotation ann : annos = cl.getAnnotations()) {
            if (!(ann instanceof Document)) continue;
            return ((Document)ann).collection();
        }
        String name = cl.getName();
        return (name = name.substring(name.lastIndexOf(".") + 1).toLowerCase()).endsWith("bean") ? name.substring(0, name.length() - 4) : name;
    }

    public Field fetchDeclaredField(String fieldName) {
        return AbstractEntityBean.fetchDeclaredField(this.getClass(), fieldName);
    }

    public static Field fetchDeclaredField(Class<?> classDefine, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = classDefine.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if (classDefine.getSuperclass() == null) break block2;
                return AbstractEntityBean.fetchDeclaredField(classDefine.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public StringBuffer fetchAllDeclaredField(StringBuffer sb) {
        return AbstractEntityBean.fetchAllDeclaredField(this.getClass(), sb);
    }

    public static StringBuffer fetchAllDeclaredField(Class<?> classDefine, StringBuffer sb) {
        Field[] flds;
        for (Field fld : flds = classDefine.getDeclaredFields()) {
            if (Modifier.isStatic(fld.getModifiers())) continue;
            sb.append(fld.getName() + ",");
        }
        if (classDefine.getSuperclass() != null) {
            AbstractEntityBean.fetchAllDeclaredField(classDefine.getSuperclass(), sb);
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public void validateBean(Class<?> groupClazz) throws BeanValidateException {
        Set<ConstraintViolation<Object>> msgs = ValidatorUtils.validate(this, groupClazz);
        if (msgs != null && msgs.size() > 0) {
            ConstraintViolation<Object> cv = msgs.iterator().next();
            throw new BeanValidateException(cv.getPropertyPath().toString(), AbstractEntityBean.formatValidateMessage(cv, null));
        }
    }

    public void validateBean(String ... ignores) throws BeanValidateException {
        AbstractEntityBean.validateBean(this, ignores);
    }

    public static void validateBean(Object object, String ... ignores) throws BeanValidateException {
        Set<ConstraintViolation<Object>> msgs = ValidatorUtils.validate(object, new Class[0]);
        if (msgs != null && msgs.size() > 0) {
            for (ConstraintViolation<Object> cv : msgs) {
                String key = cv.getPropertyPath().toString();
                boolean exist = false;
                for (int i = 0; ignores != null && i < ignores.length; ++i) {
                    if (!key.equalsIgnoreCase(ignores[i])) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new BeanValidateException(key, AbstractEntityBean.formatValidateMessage(cv, object));
            }
        }
    }

    private static String formatValidateMessage(ConstraintViolation<?> cv, Object object) {
        StringBuffer msg = new StringBuffer();
        String type = cv.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
        msg.append(cv.getPropertyPath().toString());
        msg.append(" is [" + cv.getInvalidValue() + "],");
        msg.append(cv.getMessage());
        String locale = null;
        if (object != null) {
            locale = object instanceof AbstractEntityBean ? ((AbstractEntityBean)object).getLang() : object.toString();
        }
        return MessageSourceHelper.getDefault().getMessage(type, msg.toString(), locale != null ? new Locale(locale) : null, cv.getPropertyPath().toString(), cv.getInvalidValue(), cv.getMessage());
    }

    public void validateBeanForSpecified(String ... specflds) throws BeanValidateException {
        AbstractEntityBean.validateBeanForSpecified(this, specflds);
    }

    public static void validateBeanForSpecified(Object object, String ... specflds) throws BeanValidateException {
        Set<ConstraintViolation<Object>> msgs = ValidatorUtils.validate(object, new Class[0]);
        if (msgs != null && msgs.size() > 0) {
            for (ConstraintViolation<Object> cv : msgs) {
                String key = cv.getPropertyPath().toString();
                boolean exist = false;
                for (int i = 0; specflds != null && i < specflds.length; ++i) {
                    if (!key.equalsIgnoreCase(specflds[i])) continue;
                    exist = true;
                    break;
                }
                if (!exist) continue;
                throw new BeanValidateException(key, AbstractEntityBean.formatValidateMessage(cv, object));
            }
        }
    }
}

