/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocm.common.entity;

import com.efuture.ocm.common.entity.ServiceSession;
import com.efuture.ocm.common.language.MessageSourceHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ServiceResponse {
    String returncode;
    Object data;
    List<String> elapsed;
    List<String> warnmsg;

    public String getReturncode() {
        return this.returncode;
    }

    public void setReturncode(String returncode) {
        this.returncode = returncode;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public List<String> getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(List<String> elapsed) {
        this.elapsed = elapsed;
    }

    public void addElapsed(String msg, long start_time, long end_time) {
        if (this.elapsed == null) {
            this.elapsed = new ArrayList<String>();
        }
        this.elapsed.add(msg + ": " + (end_time - start_time) + " ms");
    }

    public List<String> getWarnmsg() {
        return this.warnmsg;
    }

    public void setWarnmsg(List<String> warnmsg) {
        this.warnmsg = warnmsg;
    }

    public void addWarnmsg(String msg, Object ... args) {
        if (this.warnmsg == null) {
            this.warnmsg = new ArrayList<String>();
        }
        this.warnmsg.add(MessageSourceHelper.formatMessage(msg, args));
    }

    public static ServiceResponse buildSuccess(Object obj) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode("0");
        response.setData(obj);
        return response;
    }

    public static ServiceResponse buildFailure(ServiceSession session, String returncode) {
        return ServiceResponse.buildFailure(session, returncode, null, new Object[0]);
    }

    public static ServiceResponse buildFailure(ServiceSession session, String returncode, String formatmsg, Object ... args) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(returncode);
        response.setData(MessageSourceHelper.getDefault().getMessage(returncode, formatmsg, session != null && session.getLocale() != null ? new Locale(session.getLocale()) : null, args));
        return response;
    }
}

