/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocm.common.language;

import com.efuture.ocm.common.util.SpringBeanFactory;
import java.text.MessageFormat;
import java.util.Locale;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.StringUtils;

public class MessageSourceHelper {
    private ResourceBundleMessageSource messageSource;

    public static MessageSourceHelper getDefault() {
        return (MessageSourceHelper)SpringBeanFactory.getBean("messageSourceHelper");
    }

    public static String getMessage(String code, String locale, Object ... args) {
        return MessageSourceHelper.getDefault().getMessage(code, code, StringUtils.isEmpty((Object)locale) ? null : new Locale(locale), args);
    }

    public static String formatMessage(String message, Object ... args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = String.valueOf(args[i]);
        }
        return MessageFormat.format(message, args);
    }

    public String getMessage(String code, String defaultMessage, Locale locale, Object ... args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = String.valueOf(args[i]);
        }
        String msg = this.messageSource.getMessage(code, args, defaultMessage, locale);
        if (code.equalsIgnoreCase("10000") || code.equalsIgnoreCase("50000")) {
            try {
                if (args != null && args.length > 0 && !StringUtils.isEmpty((Object)defaultMessage)) {
                    defaultMessage = MessageFormat.format(defaultMessage, args);
                }
                msg = defaultMessage;
            }
            catch (Exception ex) {
                msg = defaultMessage;
            }
        }
        return msg != null ? msg.trim() : msg;
    }

    public void setMessageSource(ResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

