/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocm.common.util;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanFactory {
    static ApplicationContext context = null;
    static String[] ContextXml = null;

    SpringBeanFactory() {
    }

    public static Object getBean(String name) {
        return SpringBeanFactory.getContext().getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringBeanFactory.getContext().getBean(name, clazz);
    }

    public static boolean containsBean(String name) {
        return SpringBeanFactory.getContext().containsBean(name);
    }

    private static synchronized void getInstance() {
        if (context == null) {
            context = SpringBeanFactory.getWebApplicationContext();
        }
        if (context == null) {
            context = SpringBeanFactory.getApplicationContext();
        }
    }

    public static ApplicationContext getContext() {
        if (context != null) {
            return context;
        }
        SpringBeanFactory.getInstance();
        return context;
    }

    private static void afterInitNotify(ApplicationContext cont) {
        System.out.println("start spring afterInitNotify.");
        try {
            ApplicationEvent event = (ApplicationEvent)cont.getBean("afterInitNotify");
            cont.publishEvent(event);
        }
        catch (Exception e) {
            System.out.println("bean [afterInitNotify] not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationContext getTemporaryContext(String contextFile) {
        ClassPathXmlApplicationContext cont = null;
        try {
            cont = new ClassPathXmlApplicationContext(contextFile);
        }
        finally {
            if (cont != null) {
                SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
            }
        }
        return cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApplicationContext getWebApplicationContext() {
        WebApplicationContext cont = null;
        try {
            cont = ContextLoader.getCurrentWebApplicationContext();
        }
        finally {
            if (cont != null) {
                SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
            }
        }
        return cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationContext getApplicationContext() {
        ClassPathXmlApplicationContext cont = null;
        try {
            cont = ContextXml == null ? new ClassPathXmlApplicationContext(new String[]{"classpath*:**/applicationContext-*.xml", "classpath*:**/componentContext-*.xml"}) : new ClassPathXmlApplicationContext(ContextXml);
            if (cont == null) return cont;
        }
        catch (Throwable throwable) {
            if (cont == null) throw throwable;
            SpringBeanFactory.afterInitNotify(cont);
            throw throwable;
        }
        SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
        return cont;
    }

    public static void setApplicationContextXml(String[] contextFile) {
        ContextXml = contextFile;
    }
}

