/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocm.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.ws.rs.core.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class Utils {
    private static final String CR = " \n          at ";
    private static boolean isDetailException;
    private static int detailDepth;

    public static String getLastExceptionMessage(Exception e) {
        return Utils.getLastExceptionMessage(e, isDetailException);
    }

    protected static String getLastExceptionMessage(Exception e, boolean all) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
            e = t;
        }
        while ((t = t.getCause()) != null && t.getCause() != null) {
        }
        if (t == null) {
            t = e;
        }
        String errmsg = t.getClass().getName() + ": " + t.getMessage();
        StackTraceElement[] stes = t.getStackTrace();
        if (stes != null && stes.length > 0) {
            errmsg = errmsg + CR + stes[0].toString();
            if (all) {
                StringBuffer sb = new StringBuffer();
                for (int i = 1; i < stes.length && i < detailDepth; ++i) {
                    sb.append(CR + stes[i].toString());
                }
                errmsg = errmsg + sb.toString();
            } else {
                String privmsg = null;
                String currmsg = null;
                for (int i = 1; i < stes.length; ++i) {
                    privmsg = stes[i - 1].toString();
                    if (stes[i].toString().indexOf("com.efuture.") < 0) continue;
                    if (i == 1) {
                        privmsg = null;
                    }
                    currmsg = stes[i].toString();
                    break;
                }
                if (currmsg != null) {
                    if (privmsg != null) {
                        errmsg = errmsg + " \n          at ... \n          at " + privmsg;
                    }
                    errmsg = errmsg + CR + currmsg;
                }
            }
        }
        return errmsg;
    }

    public static Object toNormalJSONObject(Object data) {
        JSONObject jsondata = null;
        if (data instanceof JSONObject) {
            jsondata = (JSONObject)data;
        } else {
            try {
                jsondata = JSON.parseObject((String)JSON.toJSONStringWithDateFormat((Object)data, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
            }
            catch (Exception ex) {
                return data;
            }
        }
        Set keys = jsondata.keySet();
        for (String key : keys) {
            if (jsondata.get((Object)key) instanceof Long) {
                jsondata.put(key, (Object)String.valueOf(jsondata.getLong(key)));
                continue;
            }
            if (jsondata.get((Object)key) instanceof JSONObject) {
                jsondata.put(key, Utils.toNormalJSONObject(jsondata.getJSONObject(key)));
                continue;
            }
            if (!(jsondata.get((Object)key) instanceof JSONArray)) continue;
            JSONArray array = jsondata.getJSONArray(key);
            for (int i = 0; i < array.size(); ++i) {
                Object o = array.get(i);
                if (o instanceof Long) {
                    array.set(i, (Object)String.valueOf(o));
                    continue;
                }
                if (!(o instanceof JSONObject)) continue;
                array.set(i, Utils.toNormalJSONObject(o));
            }
        }
        return jsondata;
    }

    public static boolean stringArrayContainsKey(String[] array, String key, boolean ignoreCase) {
        if (array == null) {
            return false;
        }
        for (String k : array) {
            if (!(ignoreCase ? key.equalsIgnoreCase(k) : key.equals(k))) continue;
            return true;
        }
        return false;
    }

    public static String builderContentDispositionFileName(HttpHeaders headers, String filename) {
        String contentDisposition = "attachment;";
        try {
            String browser = headers.getRequestHeader("User-Agent").toString();
            contentDisposition = browser != null && browser.toLowerCase().indexOf("firefox") > 0 ? contentDisposition + "filename*=UTF-8''" + URLEncoder.encode(filename, "UTF-8") : contentDisposition + "filename=" + URLEncoder.encode(filename, "UTF-8");
        }
        catch (Exception ex) {
            contentDisposition = contentDisposition + "filename=" + filename;
        }
        return contentDisposition;
    }

    static {
        String s;
        ServletContext sc;
        isDetailException = false;
        detailDepth = 99;
        WebApplicationContext cont = ContextLoader.getCurrentWebApplicationContext();
        if (cont != null && (sc = cont.getServletContext()) != null && !StringUtils.isEmpty((Object)(s = sc.getInitParameter("detailException")))) {
            if ("true".equalsIgnoreCase(s)) {
                isDetailException = true;
                detailDepth = 99;
            } else if (Pattern.compile("[0-9]*").matcher(s).matches()) {
                isDetailException = true;
                detailDepth = Integer.parseInt(s);
            }
        }
    }
}

