/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.boot;

import com.efuture.ocp.common.cache.CacheConfig;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.cache.CacheUtilsInMemory;
import com.efuture.ocp.common.cache.CacheUtilsMemcached;
import com.efuture.ocp.common.cache.CacheUtilsRedisCluster;
import com.efuture.ocp.common.cache.CacheUtilsRedisSentinel;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.starter.config.boot.CacheProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration {
    private CacheProperties properties;

    public CacheConfiguration(CacheProperties properties) {
        this.properties = properties;
    }

    public CacheConfig getCacheConfig() {
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setServerList(this.properties.getServerList());
        cacheConfig.setPoolsize(this.properties.getPoolsize());
        cacheConfig.setRcvbuf(this.properties.getRcvbuf());
        cacheConfig.setSndbuf(this.properties.getSndbuf());
        cacheConfig.setTimeout(this.properties.getTimeout());
        cacheConfig.setMerge(this.properties.getMerge());
        cacheConfig.setHeart(this.properties.isHeart());
        cacheConfig.setRebuild(this.properties.isRebuild());
        cacheConfig.setCachetime(this.properties.getCachetime());
        cacheConfig.setRedisHost(this.properties.getRedisHost());
        cacheConfig.setRedisPort(this.properties.getRedisPort());
        cacheConfig.setRedisMaxActive(this.properties.getRedisMaxActive());
        cacheConfig.setRedisMaxIdle(this.properties.getRedisMaxIdle());
        cacheConfig.setRedisMaxWait(this.properties.getRedisMaxWait());
        cacheConfig.setRedisTimeout(this.properties.getRedisTimeout());
        cacheConfig.setRedisTestOnBorrow(this.properties.isRedisTestOnBorrow());
        cacheConfig.setRedisPassword(this.properties.getRedisPassword());
        cacheConfig.setRedisDatabase(this.properties.getRedisDatabase());
        cacheConfig.setRedisNodes(this.properties.getRedisNodes());
        cacheConfig.setRedisMaster(this.properties.getRedisMaster());
        return cacheConfig;
    }

    @Bean(name={"CacheUtils"})
    public CacheUtils CacheUtils() {
        if ("memcached".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsMemcached cacheUtils = new CacheUtilsMemcached();
            cacheUtils.setConfig(this.getCacheConfig());
            return cacheUtils;
        }
        if ("memory".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
            return cacheUtils;
        }
        if ("redis_sentinel".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsRedisSentinel cacheUtils = new CacheUtilsRedisSentinel();
            cacheUtils.setConfig(this.getCacheConfig());
            return cacheUtils;
        }
        if ("redis_cluster".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsRedisCluster cacheUtils = new CacheUtilsRedisCluster();
            cacheUtils.setConfig(this.getCacheConfig());
            return cacheUtils;
        }
        CacheUtilsRediscached cacheUtils = new CacheUtilsRediscached();
        cacheUtils.setConfig(this.getCacheConfig());
        return cacheUtils;
    }

    @Bean(name={"CacheInMemory"})
    public CacheUtils CacheInMemory() {
        CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
        return cacheUtils;
    }

    @Bean(name={"CacheRedis"})
    public CacheUtilsRediscached CacheRedis() {
        CacheUtilsRediscached cacheUtils = new CacheUtilsRediscached();
        cacheUtils.setConfig(this.getCacheConfig());
        return cacheUtils;
    }
}

