/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.boot;

import com.efuture.ocp.common.billservice.BillOperLogSrvImpl;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;

@Configuration
public class CommonConfig {
    private Logger log = LoggerFactory.getLogger(CommonConfig.class);
    @Value(value="${efuture.build.timestamp}")
    String versiondate;
    @Value(value="${efuture.build.version}")
    String version;
    @Value(value="${efuture.mall.uniqueid.hostid:60}")
    String hostid;
    @Value(value="${efuture.rest.filepath:}")
    String config;
    @Value(value="${efuture.rest.entPool:false}")
    boolean entPool;
    @Value(value="${efuture.rest.entMaxPool:100}")
    int entMaxPool;
    @Value(value="${efuture.rest.poolSize:60}")
    int rest_poolSize;
    @Value(value="${efuture.rest.maxWait:10000}")
    int maxWait;
    @Value(value="${efuture.rest.connectTimeout:200}")
    int connectTimeout;
    @Value(value="${efuture.rest.readTimeout:20000}")
    int readTimeout;

    @Bean(name={"ServiceVersion"})
    public ServiceVersion serviceVersion() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ServiceVersion sv = new ServiceVersion(this.version + " build " + this.versiondate, "y", "json");
        this.log.info("--------------------------ServiceVersion init success!-----------------------------------------");
        return sv;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource resourcebundlemessageSource() {
        ResourceBundleMessageSource rbm = new ResourceBundleMessageSource();
        rbm.setDefaultEncoding("UTF-8");
        rbm.setBasename("message");
        return rbm;
    }

    @Bean(name={"messageSourceHelper"})
    public MessageSourceHelper messageSourceHelper() {
        MessageSourceHelper rbm = new MessageSourceHelper();
        rbm.setMessageSource(this.resourcebundlemessageSource());
        return rbm;
    }

    @Bean(name={"UniqueID"})
    public UniqueID uniqueID() {
        UniqueID rbm = new UniqueID();
        rbm.setHostId(this.hostid);
        return rbm;
    }

    @Bean(name={"RestUtils"})
    public RestClientUtils RestUtils() {
        RestClientUtils udrs = new RestClientUtils(Integer.valueOf(this.rest_poolSize), this.entPool, this.entMaxPool, (long)this.maxWait, this.config);
        HashMap<String, Integer> clientProp = new HashMap<String, Integer>();
        clientProp.put("connectTimeout", this.connectTimeout);
        clientProp.put("readTimeout", this.readTimeout);
        udrs.setClientProperties(clientProp);
        return udrs;
    }

    @Bean(name={"BillOperLogSrv"})
    @ConditionalOnProperty(prefix="efuture.portal", name={"billoperlog"}, havingValue="true")
    public BillOperLogSrvImpl billOperLog(@Value(value="${efuture.portal.db:}") String storage) {
        BillOperLogSrvImpl log = new BillOperLogSrvImpl();
        if (storage != null && !"".equals(storage)) {
            storage = "StorageOperation_" + storage;
        }
        log.setStorage(storage);
        return log;
    }
}

