package com.efuture.starter.config.boot;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;

import javax.annotation.Resource;

import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class UnicodePropertiesPropertySourceLoader implements PropertySourceLoader {

	   @Override
	    public String[] getFileExtensions() {
	        return new String[]{"properties"};
	    }
		@Override
		public PropertySource<?> load(String name, org.springframework.core.io.Resource resource, String profile)
				throws IOException {
			
	        if (profile == null) {
	            Properties properties = new Properties();
	            PropertyResourceBundle bundle = new PropertyResourceBundle(new InputStreamReader(resource.getInputStream(), "UTF-8"));
	            Enumeration<String> keys = bundle.getKeys();
	            while (keys.hasMoreElements()) {
	                String key = keys.nextElement();
	                properties.setProperty(key, bundle.getString(key));
	            }
	            if (!properties.isEmpty()) {
	                return new PropertiesPropertySource(name, properties);
	            }
	        }
	        return null;
		}
}