package com.efuture.starter.config.boot;


import java.io.IOException;

import javax.sql.DataSource;

import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import com.alibaba.druid.pool.DruidDataSource;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;

@ConditionalOnProperty(prefix = "efuture.global", name = "db")
@Configuration
public class DBGlobConfig extends DBConfigAbstract
{
    /**
     * 数据源配置
     */
    @Bean(name = "globalDS")
    public DataSource onDataSource_glob()
    {
        return getDs(env.getProperty("efuture.global.db"));
    }

    /**
     * 事物管理器
     */
    @Bean(name = "globalTransactionManager")
    public DataSourceTransactionManager transactionManager_glob(@Qualifier("globalDS") DataSource datasource_glob) throws Exception
    {
        return new DataSourceTransactionManager(datasource_glob);
    }

    /**
     * 关系数据库对应的SessionFactory,被MyBatis创建用于执行SQL
     */
    @Bean(name = "globalSqlSessionFactory")
    public SqlSessionFactoryBean onSqlSessionFactoryBean_glob(@Qualifier("globalDS") DataSource datasource_glob) throws IOException
    {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        String dbtype = ((DruidDataSource) datasource_glob).getDbType();
        //setSqlSessionResources(service, dbtype, datasource);
        DBConfigExtend ext = null;

        if (SpringBeanFactory.containsBean("efuture.global.db.extend")) {
            ext = SpringBeanFactory.getBean("efuture.global.db.extend", DBConfigExtend.class);
        }

        service.setDataSource(datasource_glob);
        setSqlSessionProperties(service, dbtype, null);
        setSqlSessionAliases(service, ext != null ? ext.getSqlTypeAliases() : null);
        setSqlSessionPlugins(service, dbtype, null);
        setSqlSessionMappers(service, ext != null ? ext.getSqlMappers() : null);
        /*
        Resource resource = resourceLoader.getResource("classpath:mybatis-" + dbtype + "-config.xml");
        service.setConfigLocation(resource);
        */
        return service;
    }

    /*
     * 关系数据库数据访问对象
     */
    @Bean(name = "GlobalStorageOperation")
    public FMybatisTemplate onFMybatisTemplate_glob(@Qualifier("globalSqlSessionFactory") SqlSessionFactory sqlSessionFactory_Glob)
    {
        return new FMybatisTemplate(sqlSessionFactory_Glob, ExecutorType.BATCH);
    }
}
