package com.efuture.starter.config.boot;


import java.io.IOException;

import javax.sql.DataSource;

import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import com.alibaba.druid.pool.DruidDataSource;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;

@ConditionalOnProperty(prefix = "efuture.taskcore", name = "db")
@Configuration
public class DBTaskConfig extends DBConfigAbstract
{
    @Bean(name = "taskDS")
    public DataSource onDataSource_task()
    {
        return getDs(env.getProperty("efuture.taskcore.db"));
    }

    /**
     * 事物管理器
     */
    @Bean(name = "tasktransactionManager")
    public DataSourceTransactionManager transactionManager_task(@Qualifier("taskDS") DataSource datasource_task) throws Exception
    {
        return new DataSourceTransactionManager(datasource_task);
    }

    @Bean(name = "SqlSessionFactory_task")
    public SqlSessionFactoryBean onSqlSessionFactoryBean_task(@Qualifier("taskDS") DataSource datasource_task) throws IOException
    {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        String dbtype = ((DruidDataSource) datasource_task).getDbType();
        //setSqlSessionResources(service, dbtype, datasource);
        DBConfigExtend ext = null;

        if (SpringBeanFactory.containsBean("efuture.taskcore.db.extend")) {
            ext = SpringBeanFactory.getBean("efuture.taskcore.db.extend", DBConfigExtend.class);
        }

        service.setDataSource(datasource_task);
        setSqlSessionProperties(service, dbtype, null);
        setSqlSessionAliases(service, ext != null ? ext.getSqlTypeAliases() : null);
        setSqlSessionPlugins(service, dbtype, null);
        setSqlSessionMappers(service, ext != null ? ext.getSqlMappers() : null);
        /*
        Resource resource = resourceLoader.getResource("classpath:mybatis-" + dbtype + "-config.xml");
        service.setConfigLocation(resource);
        */
        return service;
    }

    /*
     * 关系数据库数据访问对象
     */
    @Bean(name = "StorageOperation_task")
    public FMybatisTemplate onFMybatisTemplate_task(@Qualifier("SqlSessionFactory_task") SqlSessionFactory datasource_task)
    {
        return new FMybatisTemplate(datasource_task, ExecutorType.BATCH);
    }
}
