package com.efuture.starter.config.bean;

import com.efuture.ocp.common.cache.CacheUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 缓存属性配置对象
 *
 */
@ConfigurationProperties(prefix = "efuture.cache")
public class CacheProperties
{
    private String cacheType = CacheUtils.CacheType.REDIS_SINGLE;

    /**
     * Memcached配置
     */
    private String serverList = "localhost:11211";
    private int poolsize = 2;
    private int rcvbuf = 32;
    private int sndbuf = 16;
    private int timeout = 5000;
    private int merge = 150;
    private boolean heart = true;
    private boolean rebuild = false;
    private int cachetime = 3000;

    /**
     * Redis配置
     */
    private String redisHost = "localhost";
    private int redisPort = 6379;
    private int redisMaxActive = 100;
    private int redisMaxIdle = 30;
    private int redisMaxWait = 5000;
    private int redisTimeout = 5000;
    private boolean redisTestOnBorrow = true;
    private String redisPassword = "";
    private int redisDatabase = 0;

    // Redis集群配置
    private String redisNodes;
    private String redisMaster;

    public String getCacheType()
    {
        return cacheType;
    }

    public void setCacheType(String cacheType)
    {
        this.cacheType = cacheType;
    }

    public String getServerList()
    {
        return serverList;
    }

    public void setServerList(String serverList)
    {
        this.serverList = serverList;
    }

    public int getPoolsize()
    {
        return poolsize;
    }

    public void setPoolsize(int poolsize)
    {
        this.poolsize = poolsize;
    }

    public int getRcvbuf()
    {
        return rcvbuf;
    }

    public void setRcvbuf(int rcvbuf)
    {
        this.rcvbuf = rcvbuf;
    }

    public int getSndbuf()
    {
        return sndbuf;
    }

    public void setSndbuf(int sndbuf)
    {
        this.sndbuf = sndbuf;
    }

    public int getTimeout()
    {
        return timeout;
    }

    public void setTimeout(int timeout)
    {
        this.timeout = timeout;
    }

    public int getMerge()
    {
        return merge;
    }

    public void setMerge(int merge)
    {
        this.merge = merge;
    }

    public boolean isHeart()
    {
        return heart;
    }

    public void setHeart(boolean heart)
    {
        this.heart = heart;
    }

    public boolean isRebuild()
    {
        return rebuild;
    }

    public void setRebuild(boolean rebuild)
    {
        this.rebuild = rebuild;
    }

    public int getCachetime()
    {
        return cachetime;
    }

    public void setCachetime(int cachetime)
    {
        this.cachetime = cachetime;
    }

    public String getRedisHost()
    {
        return redisHost;
    }

    public void setRedisHost(String redisHost)
    {
        this.redisHost = redisHost;
    }

    public int getRedisPort()
    {
        return redisPort;
    }

    public void setRedisPort(int redisPort)
    {
        this.redisPort = redisPort;
    }

    public int getRedisMaxActive()
    {
        return redisMaxActive;
    }

    public void setRedisMaxActive(int redisMaxActive)
    {
        this.redisMaxActive = redisMaxActive;
    }

    public int getRedisMaxIdle()
    {
        return redisMaxIdle;
    }

    public void setRedisMaxIdle(int redisMaxIdle)
    {
        this.redisMaxIdle = redisMaxIdle;
    }

    public int getRedisMaxWait()
    {
        return redisMaxWait;
    }

    public void setRedisMaxWait(int redisMaxWait)
    {
        this.redisMaxWait = redisMaxWait;
    }

    public int getRedisTimeout()
    {
        return redisTimeout;
    }

    public void setRedisTimeout(int redisTimeout)
    {
        this.redisTimeout = redisTimeout;
    }

    public boolean isRedisTestOnBorrow()
    {
        return redisTestOnBorrow;
    }

    public void setRedisTestOnBorrow(boolean redisTestOnBorrow)
    {
        this.redisTestOnBorrow = redisTestOnBorrow;
    }

    public String getRedisPassword()
    {
        return redisPassword;
    }

    public void setRedisPassword(String redisPassword)
    {
        this.redisPassword = redisPassword;
    }

    public int getRedisDatabase()
    {
        return redisDatabase;
    }

    public void setRedisDatabase(int redisDatabase)
    {
        this.redisDatabase = redisDatabase;
    }

    public String getRedisNodes()
    {
        return redisNodes;
    }

    public void setRedisNodes(String redisNodes)
    {
        this.redisNodes = redisNodes;
    }

    public String getRedisMaster()
    {
        return redisMaster;
    }

    public void setRedisMaster(String redisMaster)
    {
        this.redisMaster = redisMaster;
    }

}
