package com.efuture.starter.config.bean;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

import com.efuture.ocp.common.bpm.BpmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import com.efuture.ocp.common.billservice.BillOperLogSrvImpl;
import com.efuture.ocp.common.billservice.FileServiceImpl;
import com.efuture.ocp.common.component.GlobRuleSrv;
import com.efuture.ocp.common.component.GlobRuleSrvimpl;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;


/**
 *
 * 创建时间：2020年3月31日 下午4:05:00
 *
 * @author wanjing
 *
 * @version 2.0
 *
 *          类说明：公共配置类
 *
 */

@Configuration
public class CommonConfig
{
    private Logger log = LoggerFactory.getLogger(CommonConfig.class);

    @Value("${efuture.build.timestamp}")
    String versiondate;

    @Value("${efuture.build.version}")
    String version;

    @Value("${efuture.mall.uniqueid.hostid:60}")
    String hostid;

    @Value("${efuture.rest.filepath:}")
    String config;

    @Value("${efuture.rest.entPool:false}")
    boolean entPool;

    @Value("${efuture.rest.entMaxPool:100}")
    int entMaxPool;

    @Value("${efuture.rest.poolSize:60}")
    int rest_poolSize;

    @Value("${efuture.rest.maxWait:10000}")
    int maxWait;

    @Value("${efuture.rest.connectTimeout:200}")
    int connectTimeout;

    @Value("${efuture.rest.readTimeout:20000}")
    int readTimeout;

    @Value( "${efuture.log.logformat:json}" )
    String logformat;

    @Bean(name = "ServiceVersion")
    @ConditionalOnMissingBean(name = "ServiceVersion")
    public ServiceVersion serviceVersion()
    {
        //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ServiceVersion sv = new ServiceVersion(version + " build " + versiondate, "y", logformat);
        log.info("--------------------------ServiceVersion init success!-----------------------------------------");
        return sv;
    }

    @Bean(name = "UniqueID")
    @ConditionalOnMissingBean(name = "UniqueID")
    public UniqueID uniqueID()
    {
        UniqueID rbm = new UniqueID();
        rbm.setHostId(hostid);
        return rbm;
    }

    @Bean(name = "RestUtils")
    @ConditionalOnMissingBean(name = "RestUtils")
    public RestClientUtils RestUtils()
    {
        RestClientUtils udrs = new RestClientUtils(rest_poolSize, entPool, entMaxPool, maxWait, config);
        Map<String, Object> clientProp = new HashMap<String, Object>();
        clientProp.put("connectTimeout", connectTimeout);
        clientProp.put("readTimeout", readTimeout);
        udrs.setClientProperties(clientProp);
        return udrs;
    }

    @Bean(name = "BillOperLogSrv")
    @ConditionalOnMissingBean(name = "BillOperLogSrv")
    @ConditionalOnProperty(prefix = "efuture.portal", name = "billoperlog", havingValue = "true")
    public BillOperLogSrvImpl billOperLog(@Value("${efuture.portal.db:}") String storage)
    {
        BillOperLogSrvImpl log = new BillOperLogSrvImpl();

        if (storage != null && !"".equals(storage)) {
            storage = "StorageOperation_" + storage;
        }

        log.setStorage(storage);
        return log;
    }

    // 获取单号、编码规则的公共服务
    @Bean(name = "globRuleService")
    @ConditionalOnMissingBean(name = "globRuleService", value = GlobRuleSrv.class)
    public GlobRuleSrv globRuleSrv()
    {
        return new GlobRuleSrvimpl();
    }

    @ConditionalOnMissingBean(name = "fileExportService")
    @Bean(name = "fileExportService")
    @Scope("prototype")
    public FileServiceImpl fileExportSrv()
    {
        return new FileServiceImpl();
    }

    // 审批流服务
    @Bean(name = "BpmService")
    @ConditionalOnProperty(prefix = "efuture.bpm", name = "open", havingValue = "true")
    public BpmService bpmSrv()
    {
        return new BpmService();
    }
}
