package com.efuture.starter.config.boot;


import java.io.IOException;

import javax.sql.DataSource;

import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import com.alibaba.druid.pool.DruidDataSource;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;

@ConditionalOnProperty(prefix = "efuture.portal", name = "db")
@Configuration
public class DBPortalConfig extends DBConfigAbstract
{
    @Bean(name = "portalDS")
    public DataSource onDataSource_task()
    {
        return getDs(env.getProperty("efuture.portal.db"));
    }

    /**
     * 事物管理器
     */
    @Bean(name = "transactionManager_portal")
    public DataSourceTransactionManager transactionManager(@Qualifier("portalDS") DataSource datasource) throws Exception
    {
        return new DataSourceTransactionManager(datasource);
    }

    @Bean(name = "SqlSessionFactory_portal")
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier("portalDS") DataSource datasource) throws IOException
    {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        String dbtype = ((DruidDataSource) datasource).getDbType();
        //setSqlSessionResources(service, dbtype, datasource);
        DBConfigExtend ext = null;

        if (SpringBeanFactory.containsBean("efuture.portal.db.extend")) {
            ext = SpringBeanFactory.getBean("efuture.portal.db.extend", DBConfigExtend.class);
        }

        service.setDataSource(datasource);
        setSqlSessionProperties(service, dbtype, null);
        setSqlSessionAliases(service, ext != null ? ext.getSqlTypeAliases() : null);
        setSqlSessionPlugins(service, dbtype, null);
        setSqlSessionMappers(service, ext != null ? ext.getSqlMappers() : null);
        /*
        Resource resource = resourceLoader.getResource("classpath:mybatis-" + dbtype + "-config.xml");
        service.setConfigLocation(resource);
        */
        return service;
    }

    /*
     * 关系数据库数据访问对象
     */
    @Bean(name = "StorageOperation_portal")
    public FMybatisTemplate onFMybatisTemplate(@Qualifier("SqlSessionFactory_portal") SqlSessionFactory factory)
    {
        return new FMybatisTemplate(factory, ExecutorType.BATCH);
    }
}
