package com.efuture.starter.config.boot;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

import com.sun.jersey.spi.container.servlet.ServletContainer;

@Configuration
public class ServletConfig {
	
	@Value("${spring.application.name}")
	String appendpoint;
	
//	@Value("${spring.application.name}")
//	String appendpoint;
//	@Bean
//	public ServletRegistrationBean servletRegistrationBean() {
//	       
//		ServletRegistrationBean jerseyServlet = new ServletRegistrationBean(new ServletContainer(), "/"+appendpoint+"/*");
//		jerseyServlet.addInitParameter("com.sun.jersey.config.property.packages", "com.efuture.ocp.common.rest");
//		jerseyServlet.setLoadOnStartup(1);
//		return jerseyServlet;
//
//	}
	@ConditionalOnProperty(prefix = "package",name = "type",havingValue = "war")
	@Bean
    public FilterRegistrationBean jersey() {
    	FilterRegistrationBean bean = new FilterRegistrationBean();
    	bean.setFilter(new ServletContainer());
    	bean.addInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", "com.efuture.starter.config.boot.OcpServletContainer");
    	bean.addInitParameter("com.sun.jersey.config.property.packages", "com.efuture.ocp.common.rest");
    	//bean.addInitParameter("com.sun.jersey.config.property.packages", "com.efuture.ocp.common.rest");
		return bean;
    }
	
	@ConditionalOnProperty(prefix = "package",name = "type",havingValue = "jar", matchIfMissing = true)
	@Bean
	@Order(1)
	public ServletRegistrationBean servletRegistrationBean() {
		ServletRegistrationBean jerseyServlet = new ServletRegistrationBean(new ServletContainer(), "/"+appendpoint+"/*");
		jerseyServlet.addInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", "com.efuture.starter.config.boot.OcpServletContainer");
		jerseyServlet.addInitParameter("com.sun.jersey.config.property.packages", "com.efuture.ocp.common.rest");
		jerseyServlet.setLoadOnStartup(1);
		return jerseyServlet;

	}
	
	
	/**
<servlet><servlet-name>CORS Filter</servlet-name><servlet-class>com.sun.jersey.spi.container.servlet.ServletContainer</servlet-class> <init-param>    <param-name>com.sun.jersey.spi.container.ContainerResponseFilters</param-name>    <param-value>your.package.CORSFilter</param-value> </init-param></servlet><servlet-mapping>    <servlet-name>CORS Filter</servlet-name>    <url-pattern>/webservices/*</url-pattern></servlet-mapping>

---------------------

本文来自 svygh123 的CSDN 博客 ，全文地址请点击：https://blog.csdn.net/svygh123/article/details/51018557?utm_source=copy 
	 */
}