package com.efuture.ocp.common.autorollback;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 在方法上使用，标记方法在出错时自动回滚http调用
 * 必须是使用restclient的调用才会自动回滚
 * @author zhouwd
 *
 */
@Target({ ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AutoRollbackAnnotation {
	String name() default "";
}
