package com.efuture.ocp.common.rest;

import java.util.Date;

import org.apache.log4j.Logger;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceSession;

public class ServiceLogs {

	public interface LOGTYPE {
		public String RESPONSE = "response";
		public String REQUEST = "request";
		public String DBSTART = "db_start";
		public String DBEND = "db_end";
		public String CALL_REQUEST = "call_request";
		public String CALL_RESPONSE = "call_response";
		public String MQSEND_start = "mqsend_start";
		public String MQSEND_error = "mqsend_error";
		public String MQSEND_succ = "mqsend_succ";
		public String MQCONSUMER_start = "mqconsumer_start";
		public String MQCONSUMER_error = "mqconsumer_error";
		public String MQCONSUMER_succ = "mqconsumer_succ";
	}

	static Logger logger = Logger.getLogger(ServiceLogs.class);

	public static ServiceSession getSessionobj() {
		ServiceSession sessionobj = ServiceRestReflect.getLocale().get();
		if (sessionobj == null) {
			sessionobj = new ServiceSession();
			sessionobj.setUser_name("NIN");
			sessionobj.setRootkey(String.valueOf((new Date()).getTime()));
			sessionobj.setLogkey(sessionobj.getRootkey());
			sessionobj.setParentkey(sessionobj.getRootkey());
		}
		return sessionobj;
	}

	public static void logResponse(String logmsg, String rtncode) {
		ServiceSession sessionobj = getSessionobj();
		if (sessionobj != null) {
			sessionobj.setReturncode(rtncode);
			debuglog(sessionobj, LOGTYPE.RESPONSE, logmsg, sessionobj.getStarttime(), false);
		}
	}

	public static void logRequest(String logmsg) {
		ServiceSession sessionobj = getSessionobj();
		if (sessionobj != null) {
			sessionobj.setStarttime(System.currentTimeMillis());
			debuglog(sessionobj, LOGTYPE.REQUEST, logmsg, 0, false);
		}
	}

	public static void logCallStart(String url, String method, String request) {
		ServiceSession sessionobj = getSessionobj();
		if (sessionobj != null) {
			JSONObject logmsg = new JSONObject();
			logmsg.put("call_method", method);
			logmsg.put("call_url", url);
			logmsg.put("call_request", request);
			debuglog(sessionobj, LOGTYPE.CALL_REQUEST, logmsg.toString(), 0, false);
		}
	}

	public static void logCallError(String url, String method, String errcode, String errmsg, long starttime) {
		ServiceSession sessionobj = getSessionobj();
		if (sessionobj != null) {
			JSONObject logmsg = new JSONObject();
			logmsg.put("call_method", method);
			logmsg.put("call_url", url);
			logmsg.put("call_returncode", errcode);
			logmsg.put("call_response", errmsg);
			sessionobj.setReturncode(errcode);
			debuglog(sessionobj, LOGTYPE.CALL_RESPONSE, logmsg.toString(), starttime, true);
		}
	}

	public static void logCallSuccess(String url, String method, long starttime) {
		ServiceSession sessionobj = getSessionobj();
		if (sessionobj != null) {
			JSONObject logmsg = new JSONObject();
			logmsg.put("call_method", method);
			logmsg.put("call_url", url);
			logmsg.put("call_returncode", "0");
			debuglog(sessionobj, LOGTYPE.CALL_RESPONSE, logmsg.toString(), starttime, false);
		}
	}

	public static void logConsumeMqStart(String topic, String key, String othermsg) {
		ServiceSession sessionobj = getSessionobj();
		JSONObject logmsg = new JSONObject();
		logmsg.put("topic", topic);
		logmsg.put("keyvalue", key);
		logmsg.put("othermsg", othermsg);
		debuglog(sessionobj, LOGTYPE.MQCONSUMER_start, logmsg.toString(), 0, false);
	}

	public static void logConsumeMqError(String topic, String key, String errcode, String othermsg, long starttime) {
		ServiceSession sessionobj = getSessionobj();
		JSONObject logmsg = new JSONObject();
		logmsg.put("topic", topic);
		logmsg.put("keyvalue", key);
		logmsg.put("othermsg", othermsg);
		logmsg.put("mq_returncode", errcode);
		sessionobj.setReturncode(errcode);
		debuglog(sessionobj, LOGTYPE.MQCONSUMER_error, logmsg.toString(), starttime, true);
	}

	public static void logConsumeMqSuccess(String topic, String key, String othermsg, long starttime) {
		ServiceSession sessionobj = getSessionobj();
		JSONObject logmsg = new JSONObject();
		logmsg.put("topic", topic);
		logmsg.put("keyvalue", key);
		logmsg.put("othermsg", othermsg);
		logmsg.put("mq_returncode", "0");
		debuglog(sessionobj, LOGTYPE.MQCONSUMER_succ, logmsg.toString(), starttime, false);
	}

	public static void logSendMqStart(String topic, String key, String othermsg) {
		ServiceSession sessionobj = getSessionobj();
		JSONObject logmsg = new JSONObject();
		logmsg.put("topic", topic);
		logmsg.put("keyvalue", key);
		logmsg.put("othermsg", othermsg);
		debuglog(sessionobj, LOGTYPE.MQSEND_start, logmsg.toString(), 0, false);
	}

	public static void logSendMqError(String topic, String key, String errcode, String sendresult, String othermsg,
			long starttime) {
		ServiceSession sessionobj = getSessionobj();
		JSONObject logmsg = new JSONObject();
		logmsg.put("topic", topic);
		logmsg.put("keyvalue", key);
		logmsg.put("othermsg", othermsg);
		logmsg.put("sendresult", sendresult);
		logmsg.put("mq_returncode", errcode);
		sessionobj.setReturncode(errcode);
		debuglog(sessionobj, LOGTYPE.MQSEND_error, logmsg.toString(), starttime, true);
	}

	public static void logSendMqSuccess(String topic, String key, String sendresult, String othermsg, long starttime) {
		ServiceSession sessionobj = getSessionobj();
		JSONObject logmsg = new JSONObject();
		logmsg.put("topic", topic);
		logmsg.put("keyvalue", key);
		logmsg.put("othermsg", othermsg);
		logmsg.put("sendresult", sendresult);
		logmsg.put("mq_returncode", "0");
		debuglog(sessionobj, LOGTYPE.MQSEND_succ, logmsg.toString(), starttime, false);
	}

	private static String getDefaultFormatstr(ServiceSession sessionobj, String logtype, String logmsg,
			long starttime) {
		StringBuffer sb = new StringBuffer();
		sb.append("rootkey: ");
		sb.append(sessionobj.getRootkey());

		if (logtype.equalsIgnoreCase(LOGTYPE.REQUEST)) {
			sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
			sb.append(sessionobj.getMethod() + " , ");
			sb.append("REQUEST  : ");
			sb.append(logmsg);
			sb.append(" , entid : ");
			sb.append(sessionobj.getEnt_id());
		} else if (logtype.equalsIgnoreCase(LOGTYPE.RESPONSE)) {
			sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
			sb.append(sessionobj.getMethod() + " , ");
			sb.append("ELAPSED  : " + (System.currentTimeMillis() - starttime) + " ms , ");
			sb.append("RESPONSE : ");
			sb.append(logmsg);

		} else {
			sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
			sb.append(sessionobj.getMethod() + " , ");
			sb.append(logtype + "  : ");
			sb.append(logmsg);
			sb.append(" , url : ");
			sb.append(sessionobj.getUrl());
		}
		return sb.toString();
	}

	private static String getJsonFormatstr(final ServiceSession sessionobj, final String logtype, final String logmsg,
			final long starttime) {
		JSONObject rtn = (JSONObject) JSONObject.toJSON(sessionobj);
		rtn.put("logtype", logtype);
		rtn.put("logmsg", logmsg);
		if (starttime != 0) {
			rtn.put("elapsed", System.currentTimeMillis() - starttime);
		}
		return rtn.toString();
	}

	public static void debuglog(ServiceSession sessionobj, String logtype, String logmsg, long starttime,
			boolean iserr) {
		String msg = logmsg;
		if (ServiceVersion.getInstance().getLogFormat().equalsIgnoreCase("json")) {
			msg = getJsonFormatstr(sessionobj, logtype, logmsg, starttime);
		} else {
			msg = getDefaultFormatstr(sessionobj, logtype, logmsg, starttime);
		}
		// String msg =getIns().getJsonFormatstr(sessionobj, logtype, logmsg,
		// starttime);
		if (iserr) {
			logger.error(msg);
		} else {
			logger.info(msg);
		}

	}

	public static void debuglog(String logtype, String logmsg, long starttime) {
		ServiceSession sessionobj = getSessionobj();
		String msg = logmsg;
		if (ServiceVersion.getInstance().getLogFormat().equalsIgnoreCase("json")) {
			msg = getJsonFormatstr(sessionobj, logtype, logmsg, starttime);
		} else {
			msg = getDefaultFormatstr(sessionobj, logtype, logmsg, starttime);
		}
		// String msg =getIns().getJsonFormatstr(sessionobj, logtype, logmsg,
		// starttime);
		logger.info(msg);
	}

}
