package com.efuture.ocp.common.rest;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;

import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.FileServiceImpl;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.UrlEncoderUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.user.UserTokenInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;

@Path("/")
public class ServiceRestReflect {
	@Context
	HttpServletRequest request;
	@Context
	HttpServletResponse response;

	private static ServiceMethodReflect rcm = new ServiceMethodReflect();
	private static final ThreadLocal<ServiceSession> locale = new ThreadLocal<ServiceSession>();
	public static ThreadLocal<ServiceSession> getLocale() {
		return locale;
	}

	@GET
	@Produces("text/html;charset=UTF-8")
	@Path("/")
	public String test(@QueryParam("status") String status) {
		String uri = request.getRequestURI();
		if (uri.startsWith("/") || uri.startsWith("\\"))
			uri = uri.substring(1);
		if (uri.endsWith("/") || uri.endsWith("\\"))
			uri = uri.substring(0, uri.length() - 1);

		if ("check".equalsIgnoreCase(status)) {
			return uri + " success";
		} else if ("info".equalsIgnoreCase(status)) {
			JSONObject json = new JSONObject();
			RuntimeMXBean run = ManagementFactory.getRuntimeMXBean();
			json.put("pid", run.getName().split("@")[0]);
			json.put("server", run.getName().split("@")[1]);
			json.put("startTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(run.getStartTime()));
			return json.toJSONString();
		} else {
			ServiceVersion sv = ServiceVersion.getInstance();

			if ("openlog".equalsIgnoreCase(status))
				sv.setLogstatus(true);
			if ("closelog".equalsIgnoreCase(status))
				sv.setLogstatus(false);

			return uri + " version " + sv.getVer() + " (LogStatus: " + (sv.isLogstatus() ? "Y" : "N") + ")";
		}
	}

	@SuppressWarnings("rawtypes")
	private Map<String, String> getParameter() {
		Map<String, String> rtn = new HashMap<String, String>();
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String key = (String) e.nextElement();
			String[] values = request.getParameterValues(key);
			if (values != null && values.length > 0 && !StringUtils.isEmpty(values[0])) {
				String value = values[0];
				rtn.put(key, value);
			}
		}
		return rtn;
	}

	private void setSessionbycongou(ServiceSession session, String key, String value) {
		if ("token".equalsIgnoreCase(key)) {
			session.setToken(value);
			UserDataRangeSrv.setlocaltoken(value);
			UserTokenInfo info = UserDataRangeSrv.getlocaluser();
			if (info != null) {
				session.setEnt_id(Long.parseLong(info.getEntid()));
				session.setUser_id(Long.parseLong(info.getUserid()));
				session.setUser_code(info.getUseraccount());
				session.setUser_name(info.getUsername());
				session.setDeptcode(info.getDeptid());
				session.setDeptrealcode(info.getDeptcode());
				session.setRoleid(info.getOrgid());
				session.setRolecode(info.getOrgcode());
				session.setPostid(info.getPostid());
			}
		}
		if ("ent_id".equalsIgnoreCase(key))
			session.setEnt_id(Long.parseLong(value));
		if ("debug_status".equalsIgnoreCase(key))
			session.setDebug_status(value);
		if ("parentkey".equalsIgnoreCase(key))
			session.setParentkey(value);
		if ("rootkey".equalsIgnoreCase(key))
			session.setRootkey(value);
	}

	private void setSession(ServiceSession session, String key, String value) {
		if ("ent_id".equalsIgnoreCase(key))
			if (session.getEnt_id() == 0)
				if (!StringUtils.isEmpty(value)) {
					session.setEnt_id(Long.parseLong(value));
				}
		if ("user_id".equalsIgnoreCase(key))
			session.setUser_id(Long.parseLong(value));
		if ("user_code".equalsIgnoreCase(key))
			session.setUser_code(value);
		if ("user_name".equalsIgnoreCase(key))
			session.setUser_name(value);
		if ("locale".equalsIgnoreCase(key))
			session.setLocale(value);
		if ("debug_status".equalsIgnoreCase(key))
			session.setDebug_status(value);
		if ("token".equalsIgnoreCase(key)) {
			session.setToken(value);
			//UserDataRangeSrv.setlocaltoken(value);
		}
		if ("postid".equalsIgnoreCase(key))
			session.setPostid(value);
		if ("parentkey".equalsIgnoreCase(key))
			session.setParentkey(value);
		if ("rootkey".equalsIgnoreCase(key))
			session.setRootkey(value);
	}

	@SuppressWarnings("rawtypes")
	private String addQueryParamToJsonParam(ServiceSession session, String param, String... ignores) {
		Map<String, Object> map = new HashMap<String, Object>();

		// OpneAPI请求关键,webinAPI忽略这些字段不作为参
		String[] openkey = new String[] { "token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid",
				"portalkey" };
		String[] ss = null;
		if (session != null) {
			StringBuffer sb = new StringBuffer();
			String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
			ss = new String[openkey.length + s.length];
			for (int i = 0; i < openkey.length; i++)
				ss[i] = openkey[i];
			for (int i = 0; i < s.length; i++)
				ss[openkey.length + i] = s[i];
		} else
			ss = openkey;

		Map<String, String> rp = getParameter();
		String portalkey = rp.get("portalkey");
		boolean iscongouportal = false;
		if (!StringUtils.isEmpty(portalkey) && portalkey.equalsIgnoreCase("congou")) {
			iscongouportal = true;
		}

		Iterator iter = rp.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry) iter.next();
			String key = (String) entry.getKey();
			if (Utils.stringArrayContainsKey(ignores, key, true))
				continue;
			String[] values = request.getParameterValues(key);
			if (values != null && values.length > 0 && !StringUtils.isEmpty(values[0])) {
				String value = values[0];
				if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
					if (iscongouportal) {
						setSessionbycongou(session, key, value);
					} else {
						
						setSession(session, key, value);
					}

				} else {
					if ((value.startsWith("{") && value.endsWith("}")) || (value.startsWith("[") && value.endsWith("]"))) {
						try {
							map.put(key, JSON.parse(value));
						} catch (Exception ex) {
							map.put(key, value);
						}
					} else {
						map.put(key, value);
					}
				}
			}
		}

		// URL中有KEY=VALUE模式的参,加入到JSON参数
		if (map != null && map.size() > 0) {
			JSONObject jsonparam = null;
			if (StringUtils.isEmpty(param))
				jsonparam = new JSONObject();
			else {
				try {
					jsonparam = JSON.parseObject(param);
				} catch (Exception ex) {
					return param;
				}
			}

			for (String key : map.keySet()) {
				if (!jsonparam.containsKey(key))
					jsonparam.put(key, map.get(key));
			}

			param = jsonparam.toJSONString();
		}

		return param;
	}

	private boolean isEffective(String remoteAddr) {
		if ((null != remoteAddr) && (!"".equals(remoteAddr.trim())) && (!"unknown".equalsIgnoreCase(remoteAddr.trim())))
			return true;
		else
			return false;
	}

	private String getRemoteAddr() {
		try {
			String remoteAddr = request.getHeader("X-Forwarded-For");

			// 如果通过多级反向代理，X-Forwarded-For的值不止一个，而是一串用逗号分隔的IP值，此时取X-Forwarded-For中第一个非unknown的有效IP字符
			if (isEffective(remoteAddr) && (remoteAddr.indexOf(",") > -1)) {
				String[] array = remoteAddr.split(",");
				for (String element : array) {
					if (isEffective(element)) {
						remoteAddr = element;
						break;
					}
				}
			}
			if (!isEffective(remoteAddr))
				remoteAddr = request.getHeader("X-Real-IP");
			if (!isEffective(remoteAddr))
				remoteAddr = request.getRemoteAddr();
			if (remoteAddr != null && remoteAddr.indexOf(".") > 0)
				return remoteAddr;
			else
				return "";
		} catch (Exception e) {
			return "";
		}
	}

	@POST
	@Produces("text/plain;charset=UTF-8")
	@Path("/rest")
	public String callRestService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam) {
		String result = null;
		String remoteaddr = "";
		String rtncode = "0";
		long logkey = 0;
		String url = "";
		// 记录开始时
		long start_time = System.currentTimeMillis();

		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			UserDataRangeSrv.setlocaltoken("");
			if (ServiceVersion.getInstance().isLogstatus()) {
				remoteaddr = getRemoteAddr();
				logkey = UniqueID.getUniqueID();
				url = request.getQueryString();
			}
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
			{
				try{
					sessionobj = JSON.parseObject(session, ServiceSession.class);
				}
				catch (Exception ex1)
				{
					try{
						session = URLDecoder.decode(session, "UTF-8");
						sessionobj = JSON.parseObject(session, ServiceSession.class);
					}
					catch (Exception ex2)
					{
						throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
					}
				}
			}
			postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
			//sessionobj.setLocale("TR");
			sessionobj.setRemoteaddr(remoteaddr);
			sessionobj.setLogkey(String.valueOf(logkey));
			sessionobj.setMethod(method);
			if(StringUtils.isEmpty(sessionobj.getParentkey())){
				sessionobj.setParentkey(String.valueOf(logkey));
			}
			if(StringUtils.isEmpty(sessionobj.getRootkey())){
				sessionobj.setRootkey(String.valueOf(logkey));
			}
			sessionobj.setUrl(url);
			locale.set(sessionobj);
			// 记录传入参数
			if (ServiceVersion.getInstance().isLogstatus()) {
//				StringBuffer sb = new StringBuffer();
//				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
//				sb.append(method + " , ");
//				sb.append("REQUEST  : ");
//				sb.append(postparam);
//				sb.append(" , url : ");
//				sb.append(url);
				ServiceLogs.logRequest(postparam);
			}

			// 反射调用
			Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

			// 记录结束时间
			long end_time = System.currentTimeMillis();
			if (retdata instanceof ServiceResponse) {
				ServiceResponse response = (ServiceResponse) retdata;
				response.addElapsed("总耗时", start_time, end_time);

				// 非调试状态不输出日志
				if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
					// 记录输入输出日志时总是记录耗时数据
					if (!ServiceVersion.getInstance().isLogstatus())
						response.setElapsed(null);
					response.setWarnmsg(null);
				}
				rtncode = response.getReturncode();
			}

			if (retdata == null)
				result = "";
			else if (retdata instanceof String)
				result = (String) retdata;
			else
				result = JSON.toJSONString(Utils.toNormalJSONObject(retdata));

			return result;
		} catch (ServiceException ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			rtncode = ex.getErrorCode();
			return result;
		} catch (Exception ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			rtncode = "555";
			return result;
		} finally {
			// 记录输入输出参数
			if (ServiceVersion.getInstance().isLogstatus()) {
//				StringBuffer sb = new StringBuffer();
//				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
//				sb.append(method + " , ");
//				sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
//				sb.append("RESPONSE : ");
//				sb.append(result);
				//ServiceVersion.getInstance().debugLog(sb.toString());
				ServiceLogs.logResponse(result,rtncode);
				
			}
			UserDataRangeSrv.setlocaltoken("");
			locale.remove();
		}
	}

	@POST
	@Produces("text/plain;charset=UTF-8")
	@Path("/restomni")
	public String callRestService_omni(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam) {
		String result = null;
		String remoteaddr = "";
		long logkey = 0;
		String url = "";
		// 记录开始时间
		long start_time = System.currentTimeMillis();

		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			UserDataRangeSrv.setlocaltoken("");
			if (ServiceVersion.getInstance().isLogstatus()) {
				remoteaddr = getRemoteAddr();
				logkey = UniqueID.getUniqueID();
				url = request.getQueryString();
			}
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);
			postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
			sessionobj.setEnt_id(0);
			sessionobj.setToken("");
			UserDataRangeSrv.setlocaltoken("");
			// 记录传入参数
			if (ServiceVersion.getInstance().isLogstatus()) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
				sb.append(method + " , ");
				sb.append("REQUEST  : ");
				sb.append(postparam);
				sb.append(" , url : ");
				sb.append(url);
				ServiceVersion.getInstance().debugLog(sb.toString());
			}

			// 反射调用
			Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

			// 记录结束时间
			long end_time = System.currentTimeMillis();
			ServiceResponse response = null;
			if (retdata instanceof ServiceResponse) {
				response = (ServiceResponse) retdata;
				response.addElapsed("总耗时", start_time, end_time);

				// 非调试状态不输出日志
				if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
					// 记录输入输出日志时总是记录耗时数据
					if (!ServiceVersion.getInstance().isLogstatus())
						response.setElapsed(null);
					response.setWarnmsg(null);
				}

			} else {
				if (retdata == null) {
					retdata = "";
				}
				response = ServiceResponse.buildSuccess(retdata);
			}
			result = JSON.toJSONString(Utils.toNormalJSONObject(response));
			return result;
		} catch (ServiceException ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return result;
		} catch (Exception ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return result;
		} finally {
			// 记录输入输出参数
			if (ServiceVersion.getInstance().isLogstatus()) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
				sb.append(method + " , ");
				sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
				sb.append("RESPONSE : ");
				sb.append(result);
				ServiceVersion.getInstance().debugLog(sb.toString());
			}
			UserDataRangeSrv.setlocaltoken("");
		}
	}

	@POST
	@Produces("text/plain;charset=UTF-8")
	@Path("/ptrest")
	public String callRestService_pt(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam) {
		String result = null;
		String remoteaddr = "";
		long logkey = 0;
		String url = "";
		// 记录开始时
		long start_time = System.currentTimeMillis();

		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			UserDataRangeSrv.setlocaltoken("");
			if (ServiceVersion.getInstance().isLogstatus()) {
				remoteaddr = getRemoteAddr();
				logkey = UniqueID.getUniqueID();
				url = request.getQueryString();
			}
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);
			postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");

			// 记录传入参数
			if (ServiceVersion.getInstance().isLogstatus()) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
				sb.append(method + " , ");
				sb.append("REQUEST  : ");
				sb.append(postparam);
				sb.append(" , url : ");
				sb.append(url);
				ServiceVersion.getInstance().debugLog(sb.toString());
			}

			// 反射调用
			Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

			// 记录结束时间
			long end_time = System.currentTimeMillis();
			ServiceResponse response = null;
			if (retdata instanceof ServiceResponse) {
				response = (ServiceResponse) retdata;
				response.addElapsed("总耗时", start_time, end_time);

				// 非调试状态不输出日志
				if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
					// 记录输入输出日志时总是记录耗时数据
					if (!ServiceVersion.getInstance().isLogstatus())
						response.setElapsed(null);
					response.setWarnmsg(null);
				}

			} else {
				if (retdata == null) {
					retdata = "";
				}
				response = ServiceResponse.buildSuccess(retdata);
			}
			result = JSON.toJSONString(Utils.toNormalJSONObject(response));
			return result;
		} catch (ServiceException ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure_ex(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return result;
		} catch (Exception ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure_ex(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return result;
		} finally {
			// 记录输入输出参数
			if (ServiceVersion.getInstance().isLogstatus()) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
				sb.append(method + " , ");
				sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
				sb.append("RESPONSE : ");
				sb.append(result);
				ServiceVersion.getInstance().debugLog(sb.toString());
			}
			UserDataRangeSrv.setlocaltoken("");
		}
	}

	@GET
	@Produces("text/plain;charset=UTF-8")
	@Path("/rest")
	public String callRestServiceByGET(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param) {
		return callRestService(method, session, param, null);
	}

	@POST
	@Path("/import")
	@Produces("text/plain;charset=UTF-8")
	@Consumes({ MediaType.MULTIPART_FORM_DATA })
	public String callImportService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, FormDataMultiPart form) {
		List<FileImportObject> list = new ArrayList<FileImportObject>();

		try {
			ServiceVersion.getInstance().debugLog("start import.");
			
			Map<String, ?> mapFormData = form.getFields();
			Set<String> sets = (Set<String>) mapFormData.keySet();
			for (String key : sets) {
				List<?> parts = (List<?>) mapFormData.get(key);
				for (int i = 0; i < parts.size(); i++) {
					FormDataBodyPart part = (FormDataBodyPart) parts.get(i);
					String filename = part.getContentDisposition().getFileName();

					System.out.println(key + ":" + filename);
					if (StringUtils.isEmpty(filename))
						continue;

					FileImportObject fio = new FileImportObject();
					fio.setFilename(filename);
					fio.setStream(part.getValueAs(InputStream.class));
					fio.setServletrequest(request);
					list.add(fio);
				}
			}

			// 加强decode�?
			param = URLDecoder.decode(param);
			
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);
			param = addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");

			Object retdata = rcm.executeClassMethodForListParam(method, sessionobj, param, list);

			if (retdata == null)
				return "";
			else if (retdata instanceof String)
				return (String) retdata;
			else
				return JSON.toJSONString(Utils.toNormalJSONObject(retdata));
		} catch (ServiceException ex) {
			ex.printStackTrace();
			return JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
		} catch (Exception ex) {
			ex.printStackTrace();
			return JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
		} finally {
			for (FileImportObject fio : list) {
				try {
					InputStream in = fio.getStream();
					if (in != null)
						in.close();
				} catch (Exception ex) {

				}
			}
		}
	}

	@POST
	@Produces("text/plain;charset=UTF-8")
	@Path("/export")
	public Response callExportService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			@QueryParam("filename") String filename, @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;

			// 加强decode�?
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
			{
			    postparam = URLDecoder.decode(postparam);
			}
			
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);
			postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");

			// 执行导出服务
			Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

			// 返回String表示生成XLS的XML描述,可用XLS打开
			if (retdata == null)
				return Response.ok("", "text/plain;charset=UTF-8").build();
			else if (retdata instanceof ServiceResponse)
				return Response.ok(JSON.toJSONString(retdata), "text/plain;charset=UTF-8").build();
			else {
				// Firefox需要对中文文件名进行编
				if (StringUtils.isEmpty(filename))
					filename = "export.xls";
				ResponseBuilder builder = Response.ok(retdata);
				builder.header("Pragma", "No-cache");
				builder.header("Cache-Control", "No-cache");
				response.setDateHeader("Expires", 0);
				builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
				if (retdata instanceof String) {
					response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
					builder.type("application/ms-excel"); // 设置输出文件类型为excel文件
				} else {
					builder.type("application/octet-stream"); // 设置文件
				}

				return builder.build();
			}
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}

	@GET
	@Produces("text/plain;charset=UTF-8")
	@Path("/exportocm")
	public Response callExportServiceOcm(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			@QueryParam("filename") String filename, @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode�?
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);

			JSONObject json = JSONObject.parseObject(postparam);
			File fp = new File(json.getString("filename"));
			System.out.println(fp.getAbsolutePath());

			// Firefox需要对中文文件名进行编
			// 读取filename文件内容
			InputStreamReader inputReader = null;
			InputStream inputStream = new FileInputStream(fp);
			inputReader = new InputStreamReader(inputStream);
			BufferedReader bufferReader = new BufferedReader(inputReader);

			// 读取一�?
			String line = null;
			StringBuffer strBuffer = new StringBuffer();

			while ((line = bufferReader.readLine()) != null) {
				strBuffer.append(line).append("\r\n");
			}

			Object retdata = strBuffer.toString();

			if (StringUtils.isEmpty(filename))
				filename = postparam;
			ResponseBuilder builder = Response.ok(retdata);
			builder.header("Pragma", "No-cache");
			builder.header("Cache-Control", "No-cache");
			response.setDateHeader("Expires", 0);
			builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));

			response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
			// 设置输出文件类型为excel文件
			builder.type("text/plain");

			return builder.build();
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}
	
	@GET
	@Produces("text/plain;charset=UTF-8")
	@Path("/exportTxt")
	public Response callExportServiceTxt(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			@QueryParam("filename") String filename, @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;

			// 加强decode�?
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			
			// 将URL中KEY=VALUE模式的参数转换到JSON参数�?
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);
			postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");

			// 执行导出服务
			Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

			// 返回String表示生成XLS的XML描述,可用XLS打开
			if (retdata == null)
				return Response.ok("", "text/plain;charset=UTF-8").build();
			else if (retdata instanceof ServiceResponse)
				return Response.ok(JSON.toJSONString(retdata), "text/plain;charset=UTF-8").build();
			else {
				// Firefox需要对中文文件名进行编
				if (StringUtils.isEmpty(filename))
					filename = "export.xls";
				ResponseBuilder builder = Response.ok(retdata);
				builder.header("Pragma", "No-cache");
				builder.header("Cache-Control", "No-cache");
				response.setDateHeader("Expires", 0);
				builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
				if (retdata instanceof String) {
					response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
					response.setContentType("text/plain");
				} else {
					builder.type("application/octet-stream"); // 设置文件
				}

				return builder.build();
			}
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}

	@GET
	@Produces("text/plain;charset=UTF-8")
	@Path("/export")
	public Response callExportServiceByGET(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, @QueryParam("filename") String filename,
			@Context HttpHeaders headers) {
		return callExportService(method, session, param, null, filename, headers);
	}

	@GET
	@Produces("text/plain;charset=GBK")
	@Path("/exportrar")
	public Response callExportServiceOcmrar(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			@QueryParam("filename") String filename, @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);

			JSONObject json = JSONObject.parseObject(postparam);
			File fp = new File(json.getString("filename"));
			System.out.println(fp.getAbsolutePath());

			// Firefox需要对中文文件名进行编
			// 读取filename文件内容
			InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			// 清空response
			response.reset();

			ResponseBuilder builder = Response.ok(buffer);
			builder.header("Pragma", "No-cache");
			builder.header("Cache-Control", "No-cache");
			response.setDateHeader("Expires", 0);
			builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));

			response.setCharacterEncoding("GBK"); // 设置输出流为UTF-8
			// 设置输出文件类型为excel文件
			builder.type("text/plain");

			return builder.build();

		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=GBK").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=GBK").build();
		}
	}

	@GET
	@Produces("text/plain;charset=UTF-8")
	@Path("/getphoto")
	public Response callGetphotoService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, @QueryParam("filename") String filename,
			@Context HttpHeaders headers) {
		try {
			String postparam = null;
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;

			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);
			postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");

			Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

			if (retdata == null)
				return Response.ok("", "text/plain;charset=UTF-8").build();
			else if (retdata instanceof ServiceResponse)
				return Response.ok(JSON.toJSONString(retdata)).build();
			else {
				ResponseBuilder builder = (ResponseBuilder) retdata;

				return builder.build();
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			return Response.ok(Utils.getLastExceptionMessage(ex), "text/plain;charset=UTF-8").build();
		}
	}

	private Map<String, Object> getParameters(Form form) {
		Map<String, Object> result = new HashMap();
		for (Map.Entry<String, List<String>> entry : form.entrySet()) {
			List<String> value = (List) entry.getValue();
			if (!value.isEmpty()) {
				if (value.size() == 1) {
					result.put(entry.getKey(), value.get(0));
				} else {
					result.put(entry.getKey(), value);
				}
			}
		}
		return result;
	}

	private String addParamToJsonParam(ServiceSession session, Form form, String... ignores) {
		Map<String, Object> map = new HashMap();
		String[] openkey = { "token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey" };
		String[] ss = null;
		if (session != null) {
			StringBuffer sb = new StringBuffer();
			String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
			ss = new String[openkey.length + s.length];
			for (int i = 0; i < openkey.length; i++) {
				ss[i] = openkey[i];
			}
			for (int i = 0; i < s.length; i++) {
				ss[(openkey.length + i)] = s[i];
			}
		} else {
			ss = openkey;
		}
		Map<String, String> rp = getParameter();
		String portalkey = (String) rp.get("portalkey");
		boolean iscongouportal = false;
		if ((!StringUtils.isEmpty(portalkey)) && (portalkey.equalsIgnoreCase("congou"))) {
			iscongouportal = true;
		}
		Map<String, Object> rps = getParameters(form);
		map.putAll(rps);

		Iterator iter = rp.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry) iter.next();
			String key = (String) entry.getKey();
			if (!Utils.stringArrayContainsKey(ignores, key, true)) {
				String[] values = this.request.getParameterValues(key);
				if ((values != null) && (values.length > 0) && (!StringUtils.isEmpty(values[0]))) {
					String value = values[0];
					if ((ss != null) && (Utils.stringArrayContainsKey(ss, key, true))) {
						if (iscongouportal) {
							setSessionbycongou(session, key, value);
						} else {
							setSession(session, key, value);
						}
					} else if (((value.startsWith("{")) && (value.endsWith("}"))) || ((value.startsWith("[")) && (value.endsWith("]")))) {
						try {
							map.put(key, JSON.parse(value));
						} catch (Exception ex) {
							map.put(key, value);
						}
					} else {
						map.put(key, value);
					}
				}
			}
		}
		return JSONObject.toJSONString(map);
	}

	@POST
	@Produces({ "text/plain;charset=UTF-8" })
	@Path("/restful")
	public String callRestServiceful(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, @Context HttpContext context) {
		String result = null;
		String remoteaddr = "";
		long logkey = 0L;
		String url = "";

		long start_time = System.currentTimeMillis();
		try {
			UserDataRangeSrv.setlocaltoken("");
			if (ServiceVersion.getInstance().isLogstatus()) {
				remoteaddr = getRemoteAddr();
				logkey = UniqueID.getUniqueID();
				url = this.request.getQueryString();
			}
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session)) {
				sessionobj = new ServiceSession();
			} else {
				sessionobj = (ServiceSession) JSON.parseObject(session, ServiceSession.class);
			}
			String postparam = addParamToJsonParam(sessionobj, context.getRequest().getFormParameters(), new String[] { "method", "session", "param" });
			if (ServiceVersion.getInstance().isLogstatus()) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
				sb.append(method + " , ");
				sb.append("REQUEST  : ");
				sb.append(postparam);
				sb.append(" , url : ");
				sb.append(url);
				ServiceVersion.getInstance().debugLog(sb.toString());
			}
			Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);

			long end_time = System.currentTimeMillis();
			ServiceResponse response;
			if ((retdata instanceof ServiceResponse)) {
				response = (ServiceResponse) retdata;
				response.addElapsed("总耗时", start_time, end_time);
				if ((sessionobj != null) && (!"Y".equalsIgnoreCase(sessionobj.getDebug_status()))) {
					if (!ServiceVersion.getInstance().isLogstatus()) {
						response.setElapsed(null);
					}
					response.setWarnmsg(null);
				}
			}
			if (retdata == null) {
				result = "";
			} else if ((retdata instanceof String)) {
				result = (String) retdata;
			} else {
				result = JSON.toJSONString(Utils.toNormalJSONObject(retdata));
			}
			return result;
		} catch (ServiceException ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return result;
		} catch (Exception ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
			return result;
		} finally {
			if (ServiceVersion.getInstance().isLogstatus()) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + remoteaddr + " - " + logkey + "]: ");
				sb.append(method + " , ");
				sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");

				sb.append("RESPONSE : ");
				sb.append(result);
				ServiceVersion.getInstance().debugLog(sb.toString());
			}
			UserDataRangeSrv.setlocaltoken("");
		}
	}
	
	@GET
	@Produces({ "application/json", "application/octet-stream" })
	@Path("/exportExcel")
	public Response callExportExcelService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			 @Context HttpHeaders headers) {
		String remoteaddr = "";
		long logkey = 0;
		String url = "";
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode
//			if (UrlEncoderUtils.hasUrlEncoded(postparam))
//            {
//                postparam = URLDecoder.decode(postparam);
			UserDataRangeSrv.setlocaltoken("");
			if (ServiceVersion.getInstance().isLogstatus()) {
				remoteaddr = getRemoteAddr();
				logkey = UniqueID.getUniqueID();
				url = request.getQueryString();
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
			{
				try{
				sessionobj = JSON.parseObject(session, ServiceSession.class);
				}
				catch (Exception ex1)
				{
					try{
						session = URLDecoder.decode(session, "UTF-8");
						sessionobj = JSON.parseObject(session, ServiceSession.class);
					}
					catch (Exception ex2)
					{
						throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
					}
				}
			}

			postparam = addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
			JSONObject json = JSONObject.parseObject(postparam);
			sessionobj.setRemoteaddr(remoteaddr);
			sessionobj.setLogkey(String.valueOf(logkey));
			sessionobj.setMethod(method);
			if(StringUtils.isEmpty(sessionobj.getParentkey())){
				sessionobj.setParentkey(String.valueOf(logkey));
			}
			if(StringUtils.isEmpty(sessionobj.getRootkey())){
				sessionobj.setRootkey(String.valueOf(logkey));
			}
			sessionobj.setUrl(url);
			locale.set(sessionobj);
			FileServiceImpl temp = new FileServiceImpl();
			String head = request.getSession().getServletContext().getRealPath("/");
			temp.setHead(head);
			//生成文件
			String fileaname = temp.export(sessionobj, json);
			
			
			File fp = new File(fileaname);
			System.out.println(fp.getAbsolutePath());
			
			InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			
			// 清空response
			response.reset();
			
			// 4.删除压缩文件
			if (fp.exists() && fp.isFile()) {
				fp.delete();
			}

			ResponseBuilder builder = Response.ok(buffer);
			builder.header("Pragma", "No-cache");
			builder.header("Cache-Control", "No-cache");
			response.setDateHeader("Expires", 0);
			builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));

			response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
			builder.type("application/octet-stream");

			return builder.build();
			
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}
	
	@GET
	@Produces({ "application/json", "application/octet-stream" })
	@Path("/exportTemplate")
	public Response callExportTemplateService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			 @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);

			JSONObject json = JSONObject.parseObject(postparam);
			FileServiceImpl temp = new FileServiceImpl();
			String head = request.getSession().getServletContext().getRealPath("/");
			temp.setHead(head);
			//生成文件
			String fileaname = temp.exportTemplate(sessionobj, json);
			
			
			File fp = new File(fileaname);
			System.out.println(fp.getAbsolutePath());
			
			InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			
			// 清空response
			response.reset();
			
			// 4.删除压缩文件
			if (fp.exists() && fp.isFile()) {
				fp.delete();
			}

			ResponseBuilder builder = Response.ok(buffer);
			builder.header("Pragma", "No-cache");
			builder.header("Cache-Control", "No-cache");
			response.setDateHeader("Expires", 0);
			builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));

			response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
			builder.type("application/octet-stream");

			return builder.build();
			
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}
	
	@GET
	@Produces({ "application/json", "application/octet-stream" })
	@Path("/exportLC")
	public Response callExportLCService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			 @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);

			JSONObject json = JSONObject.parseObject(postparam);
			FileServiceImpl temp = new FileServiceImpl();
			String head = request.getSession().getServletContext().getRealPath("/");
			temp.setHead(head);
			//生成文件
			String fileaname = temp.exportLC(sessionobj, json);
			
			File fp = new File(fileaname);
			System.out.println(fp.getAbsolutePath());
			
			InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			
			// 清空response
			response.reset();
			
			// 4.删除压缩文件
			if (fp.exists() && fp.isFile()) {
				fp.delete();
			}

			ResponseBuilder builder = Response.ok(buffer);
			builder.header("Pragma", "No-cache");
			builder.header("Cache-Control", "No-cache");
			response.setDateHeader("Expires", 0);
			builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));

			response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
			builder.type("application/octet-stream");

			return builder.build();
			
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}
	
	@GET
	@Produces({ "application/json", "application/octet-stream" })
	@Path("/exportNC")
	public Response callExportNCService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			 @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);

			JSONObject json = JSONObject.parseObject(postparam);
			FileServiceImpl temp = new FileServiceImpl();
			String head = request.getSession().getServletContext().getRealPath("/");
			temp.setHead(head);
			//生成文件
			String fileaname = temp.exportNC(sessionobj, json);
			
			File fp = new File(fileaname);
			System.out.println(fp.getAbsolutePath());
			
			InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			
			// 清空response
			response.reset();
			
			// 4.删除压缩文件
			if (fp.exists() && fp.isFile()) {
				fp.delete();
			}

			ResponseBuilder builder = Response.ok(buffer);
			builder.header("Pragma", "No-cache");
			builder.header("Cache-Control", "No-cache");
			response.setDateHeader("Expires", 0);
			builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));

			response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
			builder.type("application/octet-stream");

			return builder.build();
			
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}
	
	
	
	@GET
	@Produces({ "application/json", "application/octet-stream" })
	@Path("/exportPrint")
	public Response callExportPrintService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam,
			 @Context HttpHeaders headers) {
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);

			JSONObject json = JSONObject.parseObject(postparam);
			String fileaname =json.getString("data");
			
			File fp = new File(fileaname);
			System.out.println(fp.getAbsolutePath());
			
			InputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			
			// 清空response
			response.reset();
			
			// 4.删除压缩文件
			if (fp.exists() && fp.isFile()) {
				fp.delete();
			}

			ResponseBuilder builder = Response.ok(buffer);
			builder.header("Pragma", "No-cache");
			builder.header("Cache-Control", "No-cache");
			response.setDateHeader("Expires", 0);
			builder.header("Content-Disposition", Utils.builderContentDispositionFileName(headers, fp.getName()));

			response.setCharacterEncoding("UTF-8"); // 设置输出流为UTF-8
			builder.type("application/octet-stream");

			return builder.build();
			
		} catch (ServiceException ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		} catch (Exception ex) {
			ex.printStackTrace();
			String error = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			return Response.ok(error, "text/plain;charset=UTF-8").build();
		}
	}
	@POST
	@Produces("text/plain;charset=UTF-8")
	@Path("/createExcel")
	public String callcreateExcelService(@QueryParam("method") String method, @QueryParam("session") String session, @QueryParam("param") String param, String postparam) {
		String result = null;
		String remoteaddr = "";
		String rtncode = "0";
		try {
			// POST的数据为空则取URL中的param
			if (StringUtils.isEmpty(postparam))
				postparam = param;
			// 加强decode
			if (UrlEncoderUtils.hasUrlEncoded(postparam))
            {
                postparam = URLDecoder.decode(postparam);
            }
			// 将URL中KEY=VALUE模式的参数转换到JSON参数
			ServiceSession sessionobj = null;
			if (StringUtils.isEmpty(session))
				sessionobj = new ServiceSession();
			else
				sessionobj = JSON.parseObject(session, ServiceSession.class);

			JSONObject json = JSONObject.parseObject(postparam);
			
			
			FileServiceImpl temp = new FileServiceImpl();
			String head = request.getSession().getServletContext().getRealPath("/");
			temp.setHead(head);
			//生成文件
			String retdata = temp.exportExcelPrint(sessionobj, json);
			Map<String ,String> m =new HashMap<String, String>();
			m.put("data", retdata);
			m.put("returncode", rtncode);
			result = JSON.toJSONString(Utils.toNormalJSONObject(m));
			return result;
		} catch (ServiceException ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
			rtncode = ex.getErrorCode();
			return result;
		} catch (Exception ex) {
			ex.printStackTrace();
			result = JSON.toJSONString(ServiceResponse.buildFailure(null, ResponseCode.EXCEPTION, Utils.getLastExceptionMessage(ex)));
			rtncode = "555";
			return result;
		} finally {
			locale.remove();
		}
	}
}
