package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.RestClientUtils;

public class RestClientUtils_DataHub extends RestClientUtils {

	public RestClientUtils_DataHub() {
		super();
	}

	public RestClientUtils_DataHub(int poolSize, long maxWait, String config) {
		super(poolSize, maxWait, config);
	}

	public RestClientUtils_DataHub(String config) {
		super(config);
	}

	private String getData(JSONObject json, String key, String defval)
	{
		if (json.containsKey(key)) return json.getString(key);
		else return defval;
	}
	
	@Override
	public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
		Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param,
				new RestClientUtils.defaultRequestCallback(), traceprex);
		ServiceResponse response = null;
		if (result != null) {
			JSONObject json = JSON.parseObject((String) result);
			response = JSON.toJavaObject(json, ServiceResponse.class);
		}
		if (response == null)
			throw new ServiceException(ResponseCode.EXCEPTION, (String) result);

		if (response.getReturncode().equals("0"))
		{
			Object hubdata = response.getData();
			if (hubdata instanceof JSONArray)
			{
				JSONArray arr = (JSONArray) hubdata;
				if (arr.size() > 0)
				{
					JSONObject row = (JSONObject)arr.get(0);
					if (!getData(row, "retcode", "0").equals("0"))
						throw new ServiceException(ResponseCode.FAILURE, getData(row, "retcode", "0").concat(":").concat(getData(row, "retmsg", "未知错误")));
					if (!getData(row, "o_retcode", "0").equals("0"))
						throw new ServiceException(ResponseCode.FAILURE, getData(row, "o_retcode", "0").concat(":").concat(getData(row, "o_retmsg", "未知错误")));
				}
			}
			else if (hubdata instanceof JSONObject)
			{
				JSONObject row = (JSONObject) hubdata;
				if (!getData(row, "retcode", "0").equals("0"))
					throw new ServiceException(ResponseCode.FAILURE, getData(row, "retcode", "0").concat(":").concat(getData(row, "retmsg", "未知错误")));
				if (!getData(row, "o_retcode", "0").equals("0"))
					throw new ServiceException(ResponseCode.FAILURE, getData(row, "o_retcode", "0").concat(":").concat(getData(row, "o_retmsg", "未知错误")));
			}
			return response;
		}
		else if (!"0".equals(response.getReturncode()))
			throw new ServiceException(response.getReturncode(), response.getData().toString());
		else {
			return response;
		}
	}
}
