/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司 FileName: ExcelUtils.java
 * Author: 亮 Date: 2015-9-25 上午11:54:59 Description: History: <author> <time>
 * <version> <description>
 * 
 */
package com.efuture.ocp.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;

/**
 * @author 亮
 * @description
 * 
 */
public class ExcelUtils
{
    public static final String XLS = "XLS";
    public static final String XLSX = "XLSX";
    public static final String DATATYPE_STRING = "S";
    public static final String DATATYPE_NUMBER = "N";
    public static final String DATATYPE_DATE = "D";
    public static final IniReader impconfig = new IniReader();
    public static final String fieldLimitChar = "	";
    public static final String fieldLimit = ",";
    
    public static boolean isNumeric(String str)
    {
    	for (int i = 0; i < str.length(); i++){
    		if (!Character.isDigit(str.charAt(i))) {
    			return false;
    		}
    	}
    	return true;
    }
    
    public static JSONArray TXTtoJSONArray(InputStream is, String flds, long maxrow,String custtype) throws Exception
    {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty(flds)) fields = flds.split(",");
        
        BufferedReader reader = new BufferedReader(new InputStreamReader(is,"gbk"));   

        //StringBuilder sb = new StringBuilder(); 
        
        String line_record = null;      
        try {      
        	while ((line_record = reader.readLine()) != null) {  
        		JSONObject json = new JSONObject();
            	String[] fields1 = line_record.split(fieldLimitChar);
            	for (int celNum = 0; celNum < fields1.length; celNum++)
                {
                    String colkey = (fields != null ? fields[celNum] : String.valueOf(celNum));
                    if (colkey.equals("birthday")) 
                    	json.put(colkey, formatval(fields1[celNum],"D"));
                    else
                    	json.put(colkey,fields1[celNum]);
                }
            	json.put("custtype", custtype);
            	array.add(json);
            	//sb.append(line_record + "\n");
        	}
        		       
        	} catch (IOException e) {      
        		e.printStackTrace(); 
        	}finally {      
        		try {      
        			is.close();      
        		} catch (IOException e) {      
        			e.printStackTrace();      
        		}      
        	}      


        if (maxrow > 0 && array.size() >= maxrow) throw new ServiceException(ResponseCode.FAILURE, "limit rows {0},excel rows {1}", maxrow, array.size());
        return array;
    }
    
    public static JSONArray TXTtoJSONAray(InputStream is, String flds, long maxrow,String custtype) throws Exception
    {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty(flds)) fields = flds.split(",");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is,"utf-8"));   

        //StringBuilder sb = new StringBuilder(); 
        
        String line_record = null;      
        try {      
        	while ((line_record = reader.readLine()) != null) {  
        		JSONObject json = new JSONObject();
            	String[] fields1 = line_record.split(fieldLimit);
            	for (int celNum = 0; celNum < fields1.length; celNum++)
                {
                    String colkey = (fields != null ? fields[celNum] : String.valueOf(celNum));
                 /*   if (colkey.equals("birthday")) 
                    	json.put(colkey, formatval(fields1[celNum],"D"));
                    else*/
                    	json.put(colkey,fields1[celNum]);
                }
            //	json.put("custtype", custtype);
            	array.add(json);
            	//sb.append(line_record + "\n");
        	}
        		       
        	} catch (IOException e) {      
        		e.printStackTrace(); 
        	}finally {      
        		try {      
        			is.close();      
        		} catch (IOException e) {      
        			e.printStackTrace();      
        		}      
        	}      


        if (maxrow > 0 && array.size() >= maxrow) throw new ServiceException(ResponseCode.FAILURE, "limit rows {0},excel rows {1}", maxrow, array.size());
        return array;
    }


    public static JSONArray XLStoJSONArray(InputStream is, String flds, long maxrow) throws Exception
    {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty(flds)) fields = flds.split(",");

        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);

        // 循环工作表Sheet
        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); numSheet++)
        {
            HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet == null) continue;

            // 第1行标题作为KEY
            if (fields == null && hssfSheet.getLastRowNum() >= 1)
            {
                HSSFRow hssfRow = hssfSheet.getRow(0);
                if (hssfRow != null)
                {
                    fields = new String[hssfRow.getLastCellNum()];
                    for (int i = 0; i < fields.length; i++)
                    {
                        HSSFCell xh = hssfRow.getCell(i);
                        fields[i] = xh.getStringCellValue();
                    }
                }
            }

            // 循环行Row,总行数为最后行数加1,第1行为标题,数据从第2行开始
            for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; rowNum++)
            {
                HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                if (hssfRow == null) continue;

                // 循环列Cell
                JSONObject json = new JSONObject();
                int celcount = (fields != null ? fields.length : hssfRow.getLastCellNum());
                for (int celNum = 0; celNum < celcount; celNum++)
                {
                    String colkey = (fields != null ? fields[celNum] : String.valueOf(celNum));

                    HSSFCell xh = hssfRow.getCell(celNum);
                    if (xh == null)
                    {
                        json.put(colkey, "");
                        continue;
                    }

                    if (xh.getCellType() == HSSFCell.CELL_TYPE_BOOLEAN) json.put(colkey, xh.getBooleanCellValue());
                    else if (xh.getCellType() == HSSFCell.CELL_TYPE_NUMERIC) json.put(colkey, xh.getNumericCellValue());
                    else if (xh.getCellType() == HSSFCell.CELL_TYPE_BLANK) json.put(colkey, "");
                    else json.put(colkey, xh.getStringCellValue());
                }

                array.add(json);
            }
        }

        if (maxrow > 0 && array.size() >= maxrow) throw new ServiceException(ResponseCode.FAILURE, "limit rows {0},excel rows {1}", maxrow, array.size());
        return array;
    }

    public static JSONArray XLSXtoJSONArray(InputStream is, String flds, long maxrow) throws Exception
    {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty(flds)) fields = flds.split(",");

        XSSFWorkbook hssfWorkbook = new XSSFWorkbook(is);

        // 循环工作表Sheet
        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); numSheet++)
        {
            XSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet == null) continue;

            // 第1行标题作为KEY
            if (fields == null && hssfSheet.getLastRowNum() >= 1)
            {
                XSSFRow hssfRow = hssfSheet.getRow(0);
                if (hssfRow != null)
                {
                    fields = new String[hssfRow.getLastCellNum()];
                    for (int i = 0; i < fields.length; i++)
                    {
                        XSSFCell xh = hssfRow.getCell(i);
                        fields[i] = xh.getStringCellValue();
                    }
                }
            }

            // 循环行Row,总行数为最后行数加1,第1行为标题,数据从第2行开始
            for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; rowNum++)
            {
                XSSFRow hssfRow = hssfSheet.getRow(rowNum);
                if (hssfRow == null) continue;

                // 循环列Cell
                JSONObject json = new JSONObject();
                int celcount = (fields != null ? fields.length : hssfRow.getLastCellNum());
                for (int celNum = 0; celNum < celcount; celNum++)
                {
                    String colkey = (fields != null ? fields[celNum] : String.valueOf(celNum));

                    XSSFCell xh = hssfRow.getCell(celNum);
                    if (xh == null)
                    {
                        json.put(colkey, "");
                        continue;
                    }

                    if (xh.getCellType() == HSSFCell.CELL_TYPE_BOOLEAN) json.put(colkey, xh.getBooleanCellValue());
                    else if (xh.getCellType() == HSSFCell.CELL_TYPE_NUMERIC) json.put(colkey, xh.getNumericCellValue());
                    else if (xh.getCellType() == HSSFCell.CELL_TYPE_BLANK) json.put(colkey, "");
                    else json.put(colkey, xh.getStringCellValue());
                }

                array.add(json);
            }
        }

        if (maxrow > 0 && array.size() >= maxrow) throw new ServiceException(ResponseCode.FAILURE, "limit rows {0},excel rows {1}", maxrow, array.size());
        return array;
    }

    public static Map<String, String> getconfig(Map<String, String> config, int sheetnum)
    {
        return config;
    }

    /**
     * 根据检查类型校验数据
     * 
     * @description
     * @param val
     * @param checktype
     * @param ibriase
     *            是否抛出异常
     * @return
     */
    public static String checkval(Object val, String checktype, boolean ibriase)
    {
        return null;

    }

    /**
     * 根据datatype做数据转换
     * 
     * @description
     * @param val
     *            要转换的数据
     * @param datatype
     *            数据类型 S-字符 N-数字 D-日期(yyyy-MM-dd HH:mm:ss)
     * @return
     * @throws ParseException
     */
    public static Object formatval(Object val, String datatype) throws ParseException
    {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty(val)) return val;
        if (StringUtils.isEmpty(datatype)) return val;

        if (datatype.equalsIgnoreCase(DATATYPE_STRING))
        {
            if (val.getClass().equals(String.class))
            {
                return val.toString().trim();
            }
            else if (val.getClass().equals(double.class))
            {
                return String.valueOf((Long) val).trim();
            }
            else if (val.getClass().equals(java.lang.Double.class))
            {
                return String.valueOf(Math.round(Double.parseDouble(String.valueOf(val).trim())));
            }
            else if (val.getClass().equals(Date.class))
            {
                return sdf.format(val);
            }
            else return val.toString();
        }
        else if (datatype.equalsIgnoreCase(DATATYPE_NUMBER))
        {  
        	if (isNumeric(val.toString())) {
        		return Double.parseDouble((String) val);
        	} else {
        		return val;
        	}
        	
        	/*if (val.getClass().equals(double.class))
            {
                return val;
            }
            else if (val.getClass().equals(String.class))
            {
            	String a_val = String.valueOf(val.toString());
				String reg_b = "-[0-9]+(.[0-9]+)?|[0-9]+(.[0-9]+)?";
				if(a_val.matches(reg_b)){
					return Double.parseDouble((String) val);
				}else{
					return val;
				}                
            }
            else
            {
                return val;
            }*/

        }
        else if (datatype.equalsIgnoreCase(DATATYPE_DATE))
        {
         	if (val.getClass().equals(Date.class)) {
				return sdf.parseObject(sdf.format(val));
			} else if (val.getClass().equals(String.class)) {
				SimpleDateFormat sdf1 ;
				String val1 = (String) val;
				if(val1.indexOf('-') > -1){
					sdf1 = new SimpleDateFormat("yyyy-MM-dd");
					if(val1.length()>10 &&val1.length()<17){
						sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
					}else if(val1.length()>17){
						sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					}
				}
				else if(val1.indexOf('/') > -1){
					sdf1 = new SimpleDateFormat("yyyy/MM/dd");
					if(val1.length()>10 &&val1.length()<17){
						sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
					}else if(val1.length()>17){
						sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
					}
				}
				else{
					return val1;
				}
				return sdf1.parseObject((String) val);
			} else {
				return val;
			}
        }
		else
        {
            return val;
        }
    }

    /**
     * execl 导入
     * 
     * @description
     * @param is
     * @param filetype
     * @param modid
     * @return
     * @throws Exception
     */
    public static JSONArray execltoJSONArray(InputStream is, String filetype, String modid) throws Exception
    {
        return execltoJSONArray(is, filetype, modid, null);
    }

	public static JSONArray execltoJSONArray(FileImportObject fio, String modid,ImpRowCallbackHandler irch) throws Exception {
		String filetype;
		if (fio.getFilename().toLowerCase().endsWith(".xlsx")) {
			filetype = ExcelUtils.XLSX;
		} else {
			filetype = ExcelUtils.XLS;
		}
		return execltoJSONArray(fio.getStream(), filetype, modid, irch);
	}
    /**
     * execl 导入
     * 
     * @description
     * @param is
     * @param filetype
     * @param modid
     * @param irch
     * @return
     * @throws Exception
     */
    public static JSONArray execltoJSONArray(InputStream is, String filetype, String modid, ImpRowCallbackHandler irch) throws Exception
    {
        Map<String, String> config = getimpconfig(modid);
        return execltoJSONArray(is, filetype, config, irch);
    }

    /**
     * execl导入
     * 
     * @description
     * @param is
     *            输入流
     * @param filetype
     *            XLS/XLSX
     * @param config
     *            导入配置
     * @param irch
     *            行处理类
     * @return
     * @throws Exception
     */
    public static JSONArray execltoJSONArray(InputStream is, String filetype, Map<String, String> config, ImpRowCallbackHandler irch) throws Exception
    {
        Workbook workbook;

        JSONArray array = new JSONArray();
        if (filetype.equalsIgnoreCase(XLS))
        {
            workbook = new HSSFWorkbook(is);
        }
        else
        {
            workbook = new XSSFWorkbook(is);
        }
        // 循环工作表Sheet
        // for (int numSheet = 0; numSheet < workbook.getNumberOfSheets();
        // numSheet++)
        // {
        int numSheet = 0;
        String[] fields = null; // 字段名
        String[] datatype = null; // 数据类型
        String[] defvalue = null; // 默认值
        String[] checktype = null;// 检查类型
        Sheet sheet = workbook.getSheetAt(numSheet);
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        Map<String, String> stconfig = getconfig(config, numSheet);
        if (!StringUtils.isEmpty(stconfig.get("fields")))
        {
            fields = stconfig.get("fields").split(",");
        }
        if (!StringUtils.isEmpty(stconfig.get("datatype")))
        {
            datatype = stconfig.get("datatype").split(",");
        }
        if (!StringUtils.isEmpty(stconfig.get("defvalue")))
        {
            defvalue = stconfig.get("defvalue").split(",");
        }
        if (!StringUtils.isEmpty(stconfig.get("checktype")))
        {
            checktype = stconfig.get("checktype").split(",");
        }
        int minRowIx = 1;
        int maxRowIx = sheet.getLastRowNum();
        boolean endflag=false;
        boolean emptyRow =  false;
        for (int rowIx = minRowIx; rowIx <= maxRowIx; rowIx++)
        {
            if(endflag){
                break;
            }
            
            if (emptyRow) {
            	  break;
            }
            
            Row row = sheet.getRow(rowIx);
            
            if (!isIllegalRow(fields,workbook,row)) {
            	emptyRow = true;
            	continue;
            }
            JSONObject json = new JSONObject();
            short minColIx = row.getFirstCellNum();
            short maxColIx = row.getLastCellNum();
            
            JSONObject errjson = new JSONObject();
            for (short colIx = minColIx; colIx <= maxColIx; colIx++)
            {
                Cell cell = row.getCell(new Integer(colIx));
                CellValue cellValue = evaluator.evaluate(cell);
                Object value = null;
                if (cellValue == null)
                {
                    if(colIx==minColIx){
                        endflag=true;
                        break;
                    }else{
                        continue; 
                    }
                }
                String colkey = (fields != null && fields.length > colIx ? fields[colIx] : String.valueOf(rowIx));
                String dtkey = (datatype != null && datatype.length > colIx ? datatype[colIx] : null);
                String dvkey = (defvalue != null && defvalue.length > colIx ? defvalue[colIx] : null);
                String ctkey = (checktype != null && checktype.length > colIx ? checktype[colIx] : null);
                // 经过公式解析，最后只存在Boolean、Numeric和String三种数据类型，此外就是Error了
                // 其余数据类型，根据官方文档，完全可以忽略http://poi.apache.org/spreadsheet/eval.html
                value = getCellValue(cell,cellValue);
              /*  switch (cellValue.getCellType())
                {
                case Cell.CELL_TYPE_BOOLEAN:
                    value = cellValue.getBooleanValue();
                    // json.put(colkey, cellValue.getBooleanValue());
                    break;
                case Cell.CELL_TYPE_NUMERIC:
                    // 这里的日期类型会被转换为数字类型，需要判别后区分处理
                    if (DateUtil.isCellDateFormatted(cell))
                    {
                        value = cell.getDateCellValue();
                        // json.put(colkey, cell.getDateCellValue());
                    }
                    else
                    {
                        value = cellValue.getNumberValue();
                        // json.put(colkey, );
                    }
                    break;
                case Cell.CELL_TYPE_STRING:
                    //value = cellValue.getStringValue();
                    // json.put(colkey, cellValue.getStringValue());
                    String tmp = cellValue.getStringValue();
                    
//                  tmp=tmp.replace("\\s+", "");
                  tmp=tmp.trim();
                  tmp=tmp.replaceAll("　| ", "");
                  tmp=tmp.trim();
                  value=tmp;
                    break;
                default:
                    value = cellValue.getStringValue();
                    break;
                }*/
                // 如果为空则设置默认值
                if (StringUtils.isEmpty(value) && !StringUtils.isEmpty(dvkey))
                {
                    value = dvkey;
                }
                // 转换数据类型
                value = formatval(value, dtkey);
                if (!StringUtils.isEmpty(ctkey))
                {
                    String msg = checkval(value, ctkey, false);
                    if (!StringUtils.isEmpty(msg))
                    {
                        errjson.put(colkey, msg);
                    }
                }

                json.put(colkey, value);
                if (errjson.size() > 0)
                {
                    json.put("errmsg", errjson);
                }
            }
            if (irch != null)
            {
                irch.processRow(json);
            }
            if(!endflag){
                array.add(json); 
            }
            
        }
        // }
        return array;
    }

    /**
     * 根据模块号找到导入配置
     * 
     * @description
     * @param modid
     * @return
     * @throws IOException
     */
    public static Map<String, String> getimpconfig(String modid) throws IOException
    {
        if (!impconfig.isinit())
        {
            String filename = WebPathUtils.getWebRootClassPath() + "/impconfig.ini";
            impconfig.init(filename);
        }
        return impconfig.getsection(modid);
    }
    
    private static  boolean isIllegalRow (String[] fields,Workbook workbook,Row row) {
    	 FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
    	 int minColIx = row.getFirstCellNum();
    	 int maxColIx = row.getLastCellNum();
    	 int numfields =  maxColIx - minColIx;
         if (fields.length  == numfields) {
        	 return true;
         } else {
        	 boolean isEmpty  = true;
             for (int colIx = minColIx; colIx <= maxColIx; colIx++)
             {
            	 Cell cell = row.getCell(new Integer(colIx));
                 CellValue cellValue = evaluator.evaluate(cell);
                 if (cellValue == null) continue;
                 Object value = getCellValue(cell,cellValue);
                 if (!StringUtils.isEmpty(value))
                 {
                	 isEmpty = false;
                	 break;
                 }
                 
               
             }
             if (!isEmpty) {
            	 return true;
             } else {
            	 return false;
             }
         }
    }
    
    private static Object getCellValue(Cell cell,CellValue cellValue) {
    	  Object value = null;
    	  switch (cellValue.getCellType())
          {
          case Cell.CELL_TYPE_BOOLEAN:
              value = cellValue.getBooleanValue();
              break;
          case Cell.CELL_TYPE_NUMERIC:
              // 这里的日期类型会被转换为数字类型，需要判别后区分处理
              if (DateUtil.isCellDateFormatted(cell))
              {
                  value = cell.getDateCellValue();
              }
              else
              {
                  value = cellValue.getNumberValue();
 
              }
              break;
          case Cell.CELL_TYPE_STRING:
              String tmp = cellValue.getStringValue();
              tmp=tmp.trim();
              tmp=tmp.replaceAll("　| ", "");
              tmp=tmp.trim();
              value=tmp;
              break;
          default:
              value = cellValue.getStringValue();
              break;
          }
    	  return value;
    }
    
}
