/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司 FileName: RestClientUtils.java
 * Author: 亮 Date: 2014-9-19 下午6:45:26 Description: History:
 * <author> <time> <version> <description>
 * 
 */
package com.efuture.ocp.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.ws.rs.core.MultivaluedMap;

import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;

import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.autorollback.AutoRollBackService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

/**
 * @author 亮
 * @description
 * 
 */
public class RestClientUtils {
	public interface requestCallback {
		// 发送
		Object onSend(String url, Client client, Object param) throws Exception;
	}

	// Client对象池,创建一个Client对象开销比较大,因此使用对象池复用对象
	public ObjectPool<Client> pool;
	private String cfgFile;
	private Map<String, Object> clientProperties;
//	private String[] compressMethods;
//
//	public String[] getCompressMethods() {
//		return compressMethods;
//	}
//
//	public void setCompressMethods(String[] compressMethods) {
//		this.compressMethods = compressMethods;
//	}

	public String[] getCompressMethods() {
		String str = queryServiceURI("compress");
		String[] compressMethods = null;
		if (!StringUtils.isEmpty(str))
			 compressMethods = str.split("\\|");
		return compressMethods;
	}
	
	public Logger logger = Logger.getLogger(RestClientUtils.class);

	public RestInfoGet restinfoget;

	public String restinfogetobj;

	public String getRestinfogetobj() {
		return restinfogetobj;
	}

	public void setRestinfogetobj(String restinfogetobj) {
		this.restinfogetobj = restinfogetobj;
	}

	public String getCfgFile() {
		return cfgFile;
	}

	public void setCfgFile(String cfgFile) {
		this.cfgFile = cfgFile;
	}

	public RestClientUtils() {
		this(null);
	}

	public RestClientUtils(String config) {
		this(0, 0, config);
	}

	public RestClientUtils(int poolSize, long maxWait, String config) {
		GenericObjectPoolConfig poolcfg = new GenericObjectPoolConfig();
		if (poolSize > 0) {
			poolcfg.setMaxTotal(poolSize);
			poolcfg.setMaxIdle(poolSize);
			poolcfg.setMinIdle(poolSize >= 2 ? poolSize / 2 : poolSize);
		}
		if (maxWait > 0)
			poolcfg.setMaxWaitMillis(maxWait);
		pool = new GenericObjectPool<Client>(new RestClientFactory(), poolcfg);
		
		if(config != null && config.startsWith("OBJ:")){
			restinfogetobj = config.substring(4);
		}
		else
		{
			cfgFile = config;
		}
		
		// initConfig();
	}

	private void initConfig() {
		if (restinfoget != null) {
			return;
		}
		if(!StringUtils.isEmpty(restinfogetobj))
		{
			if (SpringBeanFactory.containsBean(restinfogetobj)){
				restinfoget = SpringBeanFactory.getBean(restinfogetobj, RestInfoGet.class);
			}
			else
			{
				throw new ServiceException(ResponseCode.EXCEPTION, "获取对象[{0}]错误!",restinfogetobj);
			}
		}
		else if (!StringUtils.isEmpty(cfgFile) && !"globpara".equalsIgnoreCase(cfgFile)) {
			if (SpringBeanFactory.containsBean("restinfogetfrominifile")) {
				restinfoget = SpringBeanFactory.getBean("restinfogetfrominifile", RestInfoGet.class);
			} else {
				restinfoget = new RestInfoGetFromIniFile();
			}
			
		}
		else if (!StringUtils.isEmpty(cfgFile) && "globpara".equalsIgnoreCase(cfgFile))
		{
			if (SpringBeanFactory.containsBean("restinfogetfromglobpara")) {
				restinfoget = SpringBeanFactory.getBean("restinfogetfromglobpara", RestInfoGet.class);
			} else {
				restinfoget = new RestInfoGetFromIniFile();
			}
		}
		else
		{
			if (SpringBeanFactory.containsBean("restinfogetfrominifile")) {
				restinfoget = SpringBeanFactory.getBean("restinfogetfrominifile", RestInfoGet.class);
			} else {
				restinfoget = new RestInfoGetFromIniFile();
			}
		}
		
		restinfoget.init(this.cfgFile);
		// // 从数据库读取配置
		// if (!StringUtils.isEmpty(cfgFile) && cfgFile.startsWith("DB:")) {
		// // DB:TABLENAME|COND1=XXXX,COND2=XXXX
		// FStorageOperations storage = null;
		// try {
		// // 得到数据源
		// storage = SpringBeanFactory.getBean(BasicComponent.StorageOperation,
		// FStorageOperations.class);
		//
		// String[] ss = cfgFile.substring(3).split("\\|");
		// String table = ss[0].trim();
		// Criteria criteria = new Criteria();
		// if (ss.length > 1) {
		// ss = ss[1].split(",");
		// for (int i = 0; i < ss.length; i++) {
		// String[] cond = ss[i].split("=");
		// String key = cond[0].trim();
		// String val = cond[1].trim();
		// criteria = criteria.and(key).is(val);
		// }
		// }
		// Query query = new Query(criteria);
		// List<Map<String, Object>> list = storage.select(query, table);
		// if (list != null && list.size() > 0) {
		// cfgProperties = new Properties();
		// for (Map<String, Object> map : list)
		// cfgProperties.setProperty((String) map.get("key"), (String)
		// map.get("val"));
		// }
		// } finally {
		// if (storage != null)
		// storage.destroy();
		// }
		// return;
		// }
		// // 如果是globpara 就表示从globpara中取数据
		// if (!StringUtils.isEmpty(cfgFile) &&
		// "globpara".equalsIgnoreCase(cfgFile)) {
		// querybyglobpara = true;
		// return;
		// }
		// // 取restservice.ini中的配置
		// String ini = null;
		// if (StringUtils.isEmpty(cfgFile))
		// ini = WebPathUtils.getWebRootClassPath() + "/restservice.ini";
		// else {
		// if (cfgFile.startsWith("\\") || cfgFile.startsWith("/"))
		// ini = WebPathUtils.getWebRootClassPath() + cfgFile;
		// else
		// ini = cfgFile;
		// }
		//
		// try {
		// logger.info("restservice.ini path:" + ini);
		// File input = new File(ini);
		// if (input.exists()) {
		// InputStream is = new FileInputStream(input);
		// cfgProperties = new Properties();
		// cfgProperties.load(is);
		// is.close();
		//
		// // 查询压缩标志
		// String str = queryServiceURI("compress");
		// if (!StringUtils.isEmpty(str))
		// compressMethods = str.split("\\|");
		// }
		// } catch (Exception ex) {
		// ex.printStackTrace();
		// }
	}

	public Map<String, Object> getClientProperties() {
		return clientProperties;
	}

	public void setClientProperties(Map<String, Object> clientProp) {
		this.clientProperties = clientProp;
	}

	public String queryServiceURI(long ent_id, String method) {
		// String servicePath = "";
		// if (querybyglobpara) {
		// servicePath = GlobParaEnt.getvalue(ent_id, method,"");
		// } else {
		// servicePath = queryServiceURI(method);
		// }
		//
		// return servicePath;
		initConfig();
		return restinfoget.queryServiceURI(ent_id, method);
	}

	public String queryServiceURI(String method) {
		// // 根据方法名找到路径映射
		// String servicePath = "";
		//
		// if (querybyglobpara) {
		// servicePath = GlobParaEnt.getvalue(0, method);
		// if (!StringUtils.isEmpty(servicePath)) {
		// return servicePath;
		// }
		// }
		//
		// if (cfgProperties == null)
		// return null;
		//
		//
		// String curservice = method;
		// while (!StringUtils.isEmpty(curservice)) {
		// String url = cfgProperties.getProperty(curservice);
		// if (url != null && !url.equals("")) {
		// servicePath = url;
		// break;
		// } else {
		// if (curservice.equals("*"))
		// break;
		// else {
		// boolean matches = false;
		//
		// if (!curservice.endsWith(".*")) {
		// @SuppressWarnings("unchecked")
		// Enumeration<String> names = (Enumeration<String>)
		// cfgProperties.propertyNames();
		// if (names != null) {
		// do {
		// String name = names.nextElement();
		// if (!name.endsWith(".*") && name.indexOf("*") > 0) {
		// String prefix = name.substring(0, name.indexOf("*"));
		// String suffix = name.substring(name.indexOf("*") + 1);
		// if (!StringUtils.isEmpty(prefix) && curservice.startsWith(prefix)
		// && !StringUtils.isEmpty(suffix) && curservice.endsWith(suffix)) {
		// matches = true;
		// servicePath = cfgProperties.getProperty(name);
		// break;
		// }
		// }
		// } while (names.hasMoreElements());
		// }
		// }
		//
		// if (matches)
		// break;
		// else {
		// if (curservice.endsWith(".*"))
		// curservice = curservice.substring(0, curservice.lastIndexOf("."));
		// int n = curservice.lastIndexOf(".");
		// if (n > 0)
		// curservice = curservice.substring(0, n) + ".*";
		// else
		// curservice = "*";
		// }
		// }
		// }
		// }
		//
		// // 返回URL
		// return servicePath;
		initConfig();
		return restinfoget.queryServiceURI(method);
	}

	public String queryServiceURIbymkt(String method, String mktid) throws Exception {

		// // 根据方法名找到路径映射
		// String servicePath = "";
		// String curservice = method;
		// if (!StringUtils.isEmpty(curservice)) {
		// Criteria criteria =
		// Criteria.where("mktid").is(mktid).and("id").is(method);
		// Query query = new Query(criteria);
		// List<Map<String, Object>> list =
		// SpringBeanFactory.getBean("StorageOperation",
		// FStorageOperations.class)
		// .select(query, "restconfig");
		// if (list != null && !list.equals("") && list.size() > 0) {
		// servicePath = (String) list.get(0).get("resturl");
		//
		// } else {
		// Criteria c2 = Criteria.where("mktid").is("%").and("id").is(method);
		// Query q2 = new Query(c2);
		// List<Map<String, Object>> list2 = SpringBeanFactory
		// .getBean("StorageOperation", FStorageOperations.class).select(q2,
		// "restconfig");
		// if (list2 != null && !list2.equals("") && list2.size() > 0) {
		// servicePath = (String) list2.get(0).get("resturl");
		// } else {
		// throw new Exception("can't find method service url, please check
		// restconfig !");
		// }
		// }
		// }
		//
		// // 返回URL
		// return servicePath;
		initConfig();
		return restinfoget.queryServiceURIbymkt(method, mktid);
	}

	public Object sendRequest(Object session, String method, Object param, requestCallback callback) throws Exception {
		return sendRequest(session, method, param, callback, null);
	}

	private void initClientProperties(Client client) {
		if (clientProperties == null)
			return;
		for (String key : clientProperties.keySet()) {
			if ("followRedirects".equalsIgnoreCase(key))
				client.setFollowRedirects("true".equalsIgnoreCase(clientProperties.get(key).toString()) ? true : false);
			else if ("readTimeout".equalsIgnoreCase(key))
				client.setReadTimeout(Integer.parseInt(clientProperties.get(key).toString()));
			else if ("connectTimeout".equalsIgnoreCase(key))
				client.setConnectTimeout(Integer.parseInt(clientProperties.get(key).toString()));
			else if ("chunkedEncodingSize".equalsIgnoreCase(key))
				client.setChunkedEncodingSize(Integer.parseInt(clientProperties.get(key).toString()));
		}
	}

	// by zhouwd 2017-8-4 增加重写REST查询
	public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("method", method);
		map.put("url", url);
		map.put("param", param);
		// 如果直接是http的,不做转换
		if (method.toLowerCase().startsWith("http")) {
			return map;
		}
		String OverWriteObj = method + ".overwrite";
		if (SpringBeanFactory.containsBean(OverWriteObj)) {
			RestClientOverWrite row = SpringBeanFactory.getBean(OverWriteObj, RestClientOverWrite.class);
			if (row.isCanUse()) {
				map = row.doOverWrite(session, method, url, param);
			}
			return map;
		} else {
			return map;
		}

	}

	public Object sendRequest(Object session, String method, Object param, requestCallback callback, String traceprex)
			throws Exception {
		Client client = null;
		String url = null;
		long start_time = 0;
		long borro_time = 0;
		// 转换参数
		ServiceSession ss = null;
		if (session != null && session instanceof ServiceSession)
			ss = (ServiceSession) session;
		if (session != null && session instanceof Long) {
			ss = new ServiceSession();
			ss.setEnt_id((Long) session);
		}
		try {
			// 根据method找到URL
			if (method.toLowerCase().startsWith("http"))
				url = method;
			else {
				url = queryServiceURI(ss.getEnt_id(), method);
				if (StringUtils.isEmpty(url))
					throw new Exception("can't find method service url:" + method);
			}

			// by zhouwd 2017-8-4 增加重写REST查询
			if (!method.toLowerCase().startsWith("http")) {
				Map<String, Object> map = doOverWrite(session, method, url, param);
				method = map.get("method").toString();
				url = map.get("url").toString();
				param = map.get("param");
			}

			if (url.indexOf("{ent_id}") > 0 && ss != null)
				url = url.replace("{ent_id}", String.valueOf(ss.getEnt_id()));
			if (url.indexOf("{user_id}") > 0 && ss != null)
				url = url.replace("{user_id}", String.valueOf(ss.getUser_id()));
			if (url.indexOf("{user_code}") > 0 && ss != null)
				url = url.replace("{user_code}", ss.getUser_code());
			if (url.indexOf("{user_name}") > 0 && ss != null)
				url = url.replace("{user_name}", ss.getUser_name());
			if (url.indexOf("{locale}") > 0 && ss != null)
				url = url.replace("{locale}", ss.getLocale());
			if (url.indexOf("{deptcode}") > 0 && ss != null)
				url = url.replace("{deptcode}", ss.getDeptcode());
			if (url.indexOf("{token}") > 0 && ss != null & ss.getToken() != null)
				url = url.replace("{token}", ss.getToken());
			//增加转发本地服务key
			url = addlogkey(url);
			// 记录转发日志
			if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty(traceprex))
				start_time = System.currentTimeMillis();

			// 得到Rest对象
			client = pool.borrowObject();
			initClientProperties(client);

			// 记录转发日志
			if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty(traceprex))
				borro_time = System.currentTimeMillis();

			addNeedRollbackOperation(ss, method, url, param);
			ServiceLogs.logCallStart(url, method, param.toString());
			// 转发
			return onSend(callback, method, url, client, param);
		} catch (Exception ex) {
			Throwable e = ex;
			if (ex instanceof ClientHandlerException)
				e = ex.getCause();

			// by zhouwd 2017-12-12 总是记录日志
//			StringBuffer sblog = new StringBuffer();
//			sblog.append("[" + ex.getMessage() + "]: ");
//			sblog.append(method + " , ");
//			sblog.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
//			sblog.append("BORROWS: " + (borro_time - start_time) + " ms , ");
//			logger.info(sblog.toString());
			
			ServiceLogs.logCallError(url, method, "99", ex.getMessage(), start_time);

			if (e != null && e instanceof SocketException && "Connection reset".equalsIgnoreCase(e.getMessage())) {
//				StringBuffer sb = new StringBuffer();
//				sb.append("[" + ex.getMessage() + "]: ");
//				sb.append(method + " , ");
//				sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
//				sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
//				logger.info(sb.toString());

				// 废弃对象
				if (client != null)
					pool.invalidateObject(client);

				// 尝试重新得到一个对象来重新尝试请求
				client = pool.borrowObject();
				initClientProperties(client);
				return onSend(callback, method, url, client, param);
			} else
				throw ex;
		} finally {
			if (client != null) {
				try {
					pool.returnObject(client);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			
			// 记录转发日志
			if (ServiceVersion.getInstance().isLogstatus() ) {
//				StringBuffer sb = new StringBuffer();
//				sb.append("[" + traceprex + "]: ");
//				sb.append(method + " , ");
//				sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
//				sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
//				sb.append("REQUEST: " + param);
//				logger.info(sb.toString());
				ServiceLogs.logCallSuccess(url, method, start_time);
			}
		}
	}

	private String addlogkey(String url) {
		ServiceSession session = ServiceRestReflect.getLocale().get();
		if(session != null){
			if(session.getRootkey() != null){
				url = url+"&rootkey="+session.getRootkey(); 
			}
			if(session.getLogkey() != null){
				url = url+"&parentkey="+session.getLogkey(); 
			}
		}
		return url;
	}

	private void addNeedRollbackOperation(ServiceSession ss, String method, String url, Object param) {
		if (AutoRollBackService.IsEnable()) {
			AutoRollBackService.addRestOperation(ss, url, method, param);
		}

	}

	public Object sendRequestbymkt(Object session, String method, String mktid, Object param, requestCallback callback,
			String traceprex) throws Exception {
		Client client = null;
		String url = null;
		long start_time = 0;
		long borro_time = 0;

		try {
			// 根据method找到URL
			if (method.toLowerCase().startsWith("http"))
				url = method;
			else {
				url = queryServiceURIbymkt(method, mktid);
				if (StringUtils.isEmpty(url))
					throw new Exception("can't find method service url");
			}

			// 转换参数
			ServiceSession ss = null;
			if (session != null && session instanceof ServiceSession)
				ss = (ServiceSession) session;
			if (session != null && session instanceof Long) {
				ss = new ServiceSession();
				ss.setEnt_id((Long) session);
			}
			if (url.indexOf("{ent_id}") > 0 && ss != null)
				url = url.replace("{ent_id}", String.valueOf(ss.getEnt_id()));
			if (url.indexOf("{user_id}") > 0 && ss != null)
				url = url.replace("{user_id}", String.valueOf(ss.getUser_id()));
			if (url.indexOf("{user_code}") > 0 && ss != null)
				url = url.replace("{user_code}", ss.getUser_code());
			if (url.indexOf("{user_name}") > 0 && ss != null)
				url = url.replace("{user_name}", ss.getUser_name());
			if (url.indexOf("{locale}") > 0 && ss != null)
				url = url.replace("{locale}", ss.getLocale());
			if (url.indexOf("{deptcode}") > 0 && ss != null)
				url = url.replace("{deptcode}", ss.getDeptcode());
			// 记录转发日志
			if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty(traceprex))
				start_time = System.currentTimeMillis();

			// 得到Rest对象
			client = pool.borrowObject();
			initClientProperties(client);

			// 记录转发日志
			if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty(traceprex))
				borro_time = System.currentTimeMillis();

			// 转发
			return onSend(callback, method, url, client, param);
		} catch (Exception ex) {
			Throwable e = ex;
			if (ex instanceof ClientHandlerException)
				e = ex.getCause();
			if (e != null && e instanceof SocketException && "Connection reset".equalsIgnoreCase(e.getMessage())) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + ex.getMessage() + "]: ");
				sb.append(method + " , ");
				sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
				sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
				logger.info(sb.toString());

				// 废弃对象
				if (client != null)
					pool.invalidateObject(client);

				// 尝试重新得到一个对象来重新尝试请求
				client = pool.borrowObject();
				initClientProperties(client);
				return onSend(callback, method, url, client, param);
			} else
				throw ex;
		} finally {
			if (client != null) {
				try {
					pool.returnObject(client);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

			// 记录转发日志
			if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty(traceprex)) {
				StringBuffer sb = new StringBuffer();
				sb.append("[" + traceprex + "]: ");
				sb.append(method + " , ");
				sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
				sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
				sb.append("REQUEST: " + param);
				logger.info(sb.toString());
			}
		}
	}

	protected Object onSend(RestClientUtils.requestCallback call, String method, String url, Client client,
			Object param) throws Exception {
		boolean compress = false;
		String[] compressMethods = this.getCompressMethods();
		if (compressMethods != null && call instanceof defaultRequestCallback) {
			if (compressMethods.length == 1 && "*".equals(compressMethods[0]))
				compress = true;
			else
				compress = Utils.stringArrayContainsKey(compressMethods, method, true);
		}

		// 需要压缩的请求
		if (compress) {
			// 压缩数据
			ByteArrayOutputStream originalContent = new ByteArrayOutputStream();
			originalContent.write(param.toString().getBytes("UTF-8"));
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
			originalContent.writeTo(gzipOut);
			gzipOut.finish();

			// 字节数组
			param = baos.toByteArray();
		}

		Object resp = call.onSend(url, client, param);

		// 解压缩
		if (compress) {
			ByteArrayInputStream stream = new ByteArrayInputStream((byte[]) resp);
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			byte[] b = new byte[4096];
			GZIPInputStream gzip = null;
			try {
				int n = 0;
				gzip = new GZIPInputStream(stream);
				while ((n = gzip.read(b)) >= 0)
					out.write(b, 0, n);
			} finally {
				if (gzip != null) {
					try {
						gzip.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
			resp = out.toString("UTF-8");
		}

		return resp;
	}

	public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception {
		return sendRequest(session, method, param, "");
	}

	public ServiceResponse sendRequestbymkt(Object session, String method, String mktid, Object param)
			throws Exception {
		return sendRequestbymkt(session, method, mktid, param, "");
	}

	public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
		Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param,
				new RestClientUtils.defaultRequestCallback(), traceprex);
		ServiceResponse response = null;
		if (result != null) {
			JSONObject json = JSON.parseObject((String) result);
			response = JSON.toJavaObject(json, ServiceResponse.class);
		}
		if (response == null)
			throw new ServiceException(ResponseCode.EXCEPTION, (String) result);

		if (!"0".equals(response.getReturncode()))
			throw new ServiceException(response.getReturncode(), response.getData().toString());
		else {
			return response;
		}
	}

	public ServiceResponse sendRequestbymkt(Object session, String method, String mktid, Object param, String traceprex)
			throws Exception {
		Object result = RestClientUtils.getRestUtils().sendRequestbymkt(session, method, mktid, param,
				new RestClientUtils.defaultRequestCallback(), traceprex);
		ServiceResponse response = null;
		if (result != null) {
			JSONObject json = JSON.parseObject((String) result);
			response = JSON.toJavaObject(json, ServiceResponse.class);
		}
		if (response == null)
			throw new RuntimeException((String) result);
		if (!"0".equals(response.getReturncode()))
			throw new RuntimeException(response.getData().toString());
		else {
			return response;
		}
	}

	public static RestClientUtils getRestUtils() {
		return SpringBeanFactory.getBean("RestUtils", RestClientUtils.class);
	}

	public static RestClientUtils getRestUtils(String obj) {
		return SpringBeanFactory.getBean(obj, RestClientUtils.class);
	}

	public class defaultRequestCallback implements requestCallback {
		@Override
		public Object onSend(String url, Client client, Object param) throws Exception {
			WebResource webResource = client.resource(url);

			MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();

			// 判断参数为字节则标识为压缩传输
			Object resp = null;
			if (param instanceof byte[])
				resp = webResource.queryParams(queryParams).header("Content-Encoding", "gzip").post(param.getClass(),
						param);
			else
				resp = webResource.queryParams(queryParams).post(String.class, param);
			return resp;
		}
	}
}
