package com.efuture.ocp.common.util;


import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;


@Component("restinfogetfromenv")
public class RestInfoGetFromEnv implements RestInfoGet {

	public Logger logger = Logger.getLogger(RestInfoGetFromGlobpara.class);

	@Autowired
	private Environment env;

	public RestInfoGetFromEnv() {
		super();
	}

	@Override
	public void init(String configfile) {

	}

	public String[] getKey(long ent_id, String method) {
		String appid = env.getProperty("app.id");
		String[] keys = new String[6];
		keys[0] = appid + "." + method + "." + ent_id;
		keys[1] = appid + "." + method;
		keys[2] = "public" + "." + method + "." + ent_id;
		keys[3] = "public" + "." + method;
		keys[4] = method + "." + ent_id;
		keys[5] = method;
		return keys;
	}

	@Override
	public String queryServiceURI(long ent_id, String method) {
		String[] keys = getKey(ent_id, method);
		String uri = null;
		for (int i = 0; i < keys.length; i++) {
			uri = env.getProperty(keys[i]);
			if (uri != null) {
				break;
			}
		}
		return uri;
	}

	@Override
	public String queryServiceURI(String method) {
		return queryServiceURI(0, method);
	}

	@Override
	public String queryServiceURIbymkt(String method, String mktid) throws Exception {
		return queryServiceURI(0, method + "." + mktid);
	}

}
