/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.dict;

import com.efuture.ocp.common.dict.DictService;
import com.efuture.ocp.common.dict.MdmService;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="mdmdictsrv")
public class MdmDictServiceImpl
implements DictService {
    private HashMap<String, Map<String, Map<String, Object>>> dictCache = new HashMap();
    @Value(value="${efuture.report.mdmservicename:mdmdbservice}")
    public String mdmServiceName = "";
    private MdmService mdmsrv;

    @Override
    public String getDictName(long ent_id, String dicttype, String jygs, String dictcode) {
        Map<String, Object> row = this.getDictData(ent_id, dicttype, jygs, dictcode);
        if (row == null) {
            return dictcode;
        }
        return this.getMdmsrv().getMdmName(row, dicttype);
    }

    public Map<String, Object> getDictData(long ent_id, String dicttype, String jygs, String dictcode) {
        String key = ent_id + 45L + jygs + '-' + dictcode;
        Map<String, Object> dict = this.getFromCache(dicttype, key);
        if (dict == null) {
            dict = this.getRowData(ent_id, dicttype, jygs, dictcode);
            this.putCache(dicttype, key, dict);
        }
        return dict;
    }

    private Map<String, Object> getRowData(long ent_id, String dicttype, String jygs, String dictcode) {
        return this.getMdmsrv().getMdmRowData(ent_id, dicttype, jygs, dictcode);
    }

    public void putCache(String dicttype, String key, Map<String, Object> value) {
        Map<String, Map<String, Object>> dict = this.dictCache.get(dicttype);
        if (dict == null) {
            dict = new HashMap<String, Map<String, Object>>();
        }
        dict.put(key, value);
        this.dictCache.put(dicttype, dict);
    }

    public Map<String, Object> getFromCache(String dicttype, String key) {
        Map<String, Map<String, Object>> dict = this.dictCache.get(dicttype);
        if (dict == null) {
            return null;
        }
        return dict.get(key);
    }

    private String getLevelNameCol(String intype, int level) {
        return this.getLevelColBase(intype, level) + "_name";
    }

    private String getLevelColBase(String intype, int level) {
        String thiskeyStr = "efuture.report.mdm." + intype;
        String dbcol = EnvironmentParaUtils.getEnvPra(thiskeyStr + ".dbcol", intype);
        if (dbcol == null || dbcol.isEmpty()) {
            dbcol = intype;
        }
        return dbcol + "_L" + String.valueOf(level);
    }

    private String getLevelCodeCol(String intype, int level) {
        return this.getLevelColBase(intype, level) + "_code";
    }

    public Map<String, Object> genLevel(long ent_id, String jygs, Map<String, Object> rowdata, String inType, int level) {
        Map<String, Object> pmap = rowdata;
        int maxlevel = this.getMdmsrv().getMaxLevel(inType);
        do {
            String pkey = this.getLevelCodeCol(inType, level);
            String pkey_name = this.getLevelNameCol(inType, level);
            String pcode = null;
            if (pmap.get(this.getMdmsrv().getMdmPcodeCol(inType)) == null) continue;
            pcode = pmap.get(this.getMdmsrv().getMdmPcodeCol(inType)).toString();
            if ((pmap = this.getDictData(ent_id, inType, jygs, pcode)) == null) break;
            rowdata.put(pkey, pcode);
            rowdata.put(pkey_name, pmap.get("name"));
        } while (++level < maxlevel);
        return rowdata;
    }

    @Override
    public Map<String, Object> getLevelCodeName(long ent_id, String jygs, String inValue, String inType) {
        HashMap<String, Object> LevelCode = new HashMap<String, Object>();
        Map<String, Object> map = this.getDictData(ent_id, inType, jygs, inValue);
        if (map == null) {
            return LevelCode;
        }
        int level = 0;
        int maxlevel = this.getMdmsrv().getMaxLevel(inType);
        for (level = 0; level < maxlevel - 1; ++level) {
            String pkey = this.getLevelCodeCol(inType, level);
            String pkey_name = this.getLevelNameCol(inType, level);
            if (!map.containsKey(pkey) && map.get(this.getMdmsrv().getMdmPcodeCol(inType)) != null) {
                map = this.genLevel(ent_id, jygs, map, inType, 0);
            }
            if (!map.containsKey(pkey)) break;
            LevelCode.put(pkey, map.get(pkey).toString());
            LevelCode.put(pkey_name, map.get(pkey_name).toString());
        }
        return LevelCode;
    }

    public MdmService getMdmsrv() {
        if (this.mdmsrv == null) {
            this.mdmsrv = SpringBeanFactory.getBean(this.mdmServiceName, MdmService.class);
        }
        return this.mdmsrv;
    }

    public void setMdmsrv(MdmService mdmsrv) {
        this.mdmsrv = mdmsrv;
    }
}

