package com.efuture.ocp.common.bpm;

import java.util.Map;

import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;

public class BpmService {

	interface bpmservice {
		final String APPROVAL = "mss.bpm.approval";// 审批
		final String REJECT = "mss.bpm.reject";// 驳回
		final String SUBMIT = "mss.bpm.submit";// 提交
		final String REPEAL = "mss.bpm.repeal"; // 撤销
		final String GETTASK = "mss.bpm.getusertask"; // 查询任务
	}

	public static BpmService getBpmService() {
		return SpringBeanFactory.getBean("BpmService", BpmService.class);
	}
	//提交
	public ServiceResponse submit(Map<String, Object> bpmdata) throws Exception {
		return callBpmService(bpmdata, bpmservice.SUBMIT);
	}
	//驳回
	public ServiceResponse reject(Map<String, Object> bpmdata) throws Exception {
		return callBpmService(bpmdata, bpmservice.REJECT);
	}
	//审批
	public ServiceResponse approval(Map<String, Object> bpmdata) throws Exception {
		return callBpmService(bpmdata, bpmservice.APPROVAL);
	}
	//撤销
	public ServiceResponse repeal(Map<String, Object> bpmdata) throws Exception {
		return callBpmService(bpmdata, bpmservice.REPEAL);
	}
	//查询任务
	public ServiceResponse gettask(Map<String, Object> bpmdata) throws Exception {
		return callBpmService(bpmdata, bpmservice.GETTASK);
	}

	public ServiceResponse callBpmService(Map<String, Object> bpmdata, String service) throws Exception {
		ServiceSession session = new ServiceSession();
		String bpmpara = JSON.toJSONString(Utils.toNormalJSONObject(bpmdata));
		String url ;
		url = RestClientUtils.getRestUtils().queryServiceURI(service+"."+bpmdata.get("processdefkey"));
		if(StringUtils.isEmpty(url)){
		    url =  service;
		}
		String processdefkey = bpmdata.get("processdefkey").toString();
		if ("WYC".equalsIgnoreCase(processdefkey)) {
			String auth = bpmdata.get("auth").toString();
			bpmpara = bpmdata.get("sheet").toString();
			String rtn = HttpUtils.doPost(url, '['+bpmpara+']', auth);
			return null;
		} else {
			return RestClientUtils.getRestUtils().sendRequest(session, url, bpmpara);
		}
	}

}
