package com.efuture.ocp.common.dict;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;

@Component("mdmdictsrv")
public class MdmDictServiceImpl implements DictService {

	private HashMap<String, Map<String, Map<String, Object>>> dictCache = new HashMap<String, Map<String, Map<String, Object>>>();

	@Value("${efuture.report.mdmservicename:mdmdbservice}")
	public String mdmServiceName = "";

	private MdmService mdmsrv;

	@Override
	public String getDictName(long ent_id, String dicttype, String jygs, String dictcode) {
		Map<String, Object> row = getDictData(ent_id, dicttype, jygs, dictcode);
		if (row == null) {
			return dictcode;
		}
		return getMdmsrv().getMdmName(row, dicttype);
	}

	public Map<String, Object> getDictData(long ent_id, String dicttype, String jygs, String dictcode) {
		String key = ent_id + '-' + jygs + '-' + dictcode;
		Map<String, Object> dict = getFromCache(dicttype, key);
		if (dict == null) {
			dict = getRowData(ent_id, dicttype, jygs, dictcode);
			putCache(dicttype, key, dict);
		}
		return dict;
	}

	private Map<String, Object> getRowData(long ent_id, String dicttype, String jygs, String dictcode) {
		return getMdmsrv().getMdmRowData(ent_id, dicttype, jygs, dictcode);
	}

	public void putCache(String dicttype, String key, Map<String, Object> value) {
		Map<String, Map<String, Object>> dict = dictCache.get(dicttype);
		if (dict == null) {
			dict = new HashMap<String, Map<String, Object>>();
		}

		dict.put(key, value);
		dictCache.put(dicttype, dict);
	}

	public Map<String, Object> getFromCache(String dicttype, String key) {
		Map<String, Map<String, Object>> dict = dictCache.get(dicttype);
		if (dict == null) {
			return null;
		}
		return dict.get(key);
	}

	private String getLevelNameCol(String intype, int level) {
		return getLevelColBase(intype, level) + "_name";
	}

	private String getLevelColBase(String intype, int level) {
		String thiskeyStr = "efuture.report.mdm." + intype;
		String dbcol = EnvironmentParaUtils.getEnvPra(thiskeyStr + ".dbcol", intype);
		if (dbcol == null || dbcol.isEmpty()) {
			dbcol = intype;
		}
		return dbcol + "_" + "L" + String.valueOf(level);
	}

	private String getLevelCodeCol(String intype, int level) {

		return getLevelColBase(intype, level) + "_code";
	}

	public Map<String, Object> genLevel(long ent_id, String jygs, Map<String, Object> rowdata, String inType,
			int level) {

		Map<String, Object> pmap = rowdata;
		int maxlevel = getMdmsrv().getMaxLevel(inType);
		do {
			String pkey = getLevelCodeCol(inType, level);
			String pkey_name = getLevelNameCol(inType, level);
			String pcode = null;
			if (pmap.get(getMdmsrv().getMdmPcodeCol(inType)) != null) {
				pcode = pmap.get(getMdmsrv().getMdmPcodeCol(inType)).toString();
				pmap = getDictData(ent_id, inType, jygs, pcode);
				if (pmap == null) {
					break;
				} else {
					rowdata.put(pkey, pcode);
					rowdata.put(pkey_name, pmap.get("name"));
				}
			}
			level++;

		} while (level < maxlevel);
		return rowdata;

	}

	@Override
	public Map<String, Object> getLevelCodeName(long ent_id, String jygs, String inValue, String inType) {
		Map<String, Object> LevelCode = new HashMap<String, Object>();
		Map<String, Object> map = getDictData(ent_id, inType, jygs, inValue);
		if (map == null) {
			return LevelCode;
		}
		int level = 0;
		int maxlevel = getMdmsrv().getMaxLevel(inType);
		for (level = 0; level < maxlevel - 1; level++) {
			String pkey = getLevelCodeCol(inType, level);
			String pkey_name = getLevelNameCol(inType, level);
			if (!map.containsKey(pkey) && map.get(getMdmsrv().getMdmPcodeCol(inType)) != null) {
				map = genLevel(ent_id, jygs, map, inType, 0);
			}
			if (map.containsKey(pkey)) {
				LevelCode.put(pkey, map.get(pkey).toString());
				LevelCode.put(pkey_name, map.get(pkey_name).toString());
			} else {
				break;
			}
		}
		return LevelCode;
	}

	public MdmService getMdmsrv() {
		if (mdmsrv == null) {
			mdmsrv = SpringBeanFactory.getBean(mdmServiceName, MdmService.class);
		}
		return mdmsrv;
	}

	public void setMdmsrv(MdmService mdmsrv) {
		this.mdmsrv = mdmsrv;
	}

}
